/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.jpeg2000.impl;

import com.github.jaiimageio.impl.common.PackageUtil;
import com.github.jaiimageio.jpeg2000.impl.J2KImageWriter;
import java.awt.image.SampleModel;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class J2KImageWriterSpi
extends ImageWriterSpi {
    private static String[] readerSpiNames = new String[]{"com.github.jaiimageio.jpeg2000.impl.J2KImageReaderSpi"};
    private static String[] formatNames = new String[]{"jpeg 2000", "JPEG 2000", "jpeg2000", "JPEG2000"};
    private static String[] extensions = new String[]{"jp2"};
    private static String[] mimeTypes = new String[]{"image/jp2", "image/jpeg2000"};
    private boolean registered = false;

    public J2KImageWriterSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, extensions, mimeTypes, "com.github.jaiimageio.jpeg2000.impl.J2KImageWriter", STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "com_sun_media_imageio_plugins_jpeg2000_image_1.0", "com.github.jaiimageio.jpeg2000.impl.J2KMetadataFormat", null, null);
    }

    public String getDescription(Locale locale) {
        String desc = PackageUtil.getSpecificationTitle() + " JPEG 2000 Image Writer";
        return desc;
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        Object codecLibWriterSPI;
        if (this.registered) {
            return;
        }
        this.registered = true;
        Class<?> codecLibWriterSPIClass = null;
        try {
            codecLibWriterSPIClass = Class.forName("com.github.jaiimageio.jpeg2000.impl.J2KImageWriterCodecLibSpi");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (codecLibWriterSPIClass != null && (codecLibWriterSPI = registry.getServiceProviderByClass(codecLibWriterSPIClass)) != null) {
            registry.setOrdering(category, codecLibWriterSPI, this);
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        SampleModel sm = type.getSampleModel();
        if (sm.getNumBands() > 16384) {
            return false;
        }
        return sm.getDataType() >= 0 && sm.getDataType() <= 3;
    }

    public ImageWriter createWriterInstance(Object extension) throws IIOException {
        return new J2KImageWriter(this);
    }
}

