/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.core;

import com.mybatis.jpa.annotation.MapperDefinition;
import com.mybatis.jpa.annotation.StatementDefinition;
import com.mybatis.jpa.meta.PersistentMeta;
import com.mybatis.jpa.statement.MybatisStatementAdapter;
import com.mybatis.jpa.statement.SqlAssistant;
import com.mybatis.jpa.statement.StatementBuilderHolder;
import com.mybatis.jpa.statement.builder.StatementBuildable;
import java.lang.reflect.Method;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.session.Configuration;

public class PersistentMapperEnhancer
extends BaseBuilder {
    protected MapperBuilderAssistant assistant;
    protected Class<?> mapper;
    protected Class<?> type;
    protected PersistentMeta persistentMeta;
    protected MybatisStatementAdapter adapter;

    public PersistentMapperEnhancer(Configuration configuration, Class<?> mapper) {
        super(configuration);
        String resource = mapper.getName().replace(".", "/") + ".java (best guess)";
        this.assistant = new MapperBuilderAssistant(configuration, resource);
        this.adapter = new MybatisStatementAdapter(this.assistant);
        this.mapper = mapper;
        if (mapper.isAnnotationPresent(MapperDefinition.class)) {
            MapperDefinition mapperDefinition = mapper.getAnnotation(MapperDefinition.class);
            this.type = mapperDefinition.domainClass();
            this.persistentMeta = new PersistentMeta(this.type);
        }
    }

    public void enhance() {
        String resource = this.mapper.toString();
        if (!this.configuration.isResourceLoaded(resource)) {
            this.configuration.addLoadedResource(resource);
        }
        this.assistant.setCurrentNamespace(this.mapper.getName());
        if (!this.mapper.isAnnotationPresent(MapperDefinition.class)) {
            return;
        }
        for (Method method : this.mapper.getMethods()) {
            String methodType;
            StatementBuildable statementBuilder;
            if (!method.isAnnotationPresent(StatementDefinition.class) || (statementBuilder = StatementBuilderHolder.adapted(methodType = SqlAssistant.resolveMethodType(method.getName()))) == null) continue;
            statementBuilder.parseStatement(this.adapter, this.persistentMeta, method);
        }
    }
}

