/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.statement;

import com.mybatis.jpa.meta.MybatisColumnMeta;
import com.mybatis.jpa.meta.PersistentMeta;
import com.mybatis.jpa.type.OperateEnum;
import java.lang.reflect.Method;
import org.springframework.util.StringUtils;

public class SqlAssistant {
    private SqlAssistant() {
    }

    public static String buildSingleCondition(Method method, PersistentMeta persistentMeta) {
        OperateEnum operate;
        String methodType = SqlAssistant.resolveMethodType(method.getName());
        if (method.getName().equals(methodType)) {
            return "";
        }
        String expression = method.getName().substring(methodType.length() + 2);
        String fieldName = StringUtils.uncapitalize((String)expression.replace((operate = SqlAssistant.resolveOperate(expression)).getAlias(), ""));
        MybatisColumnMeta columnMeta = fieldName.equals("id") ? persistentMeta.getPrimaryColumnMeta() : persistentMeta.getColumnMetaMap().get(fieldName);
        if (operate.equals((Object)OperateEnum.ISNULL) || operate.equals((Object)OperateEnum.NOTNULL)) {
            return " WHERE " + columnMeta.getColumnName() + operate.getOperate();
        }
        return " WHERE " + columnMeta.getColumnName() + operate.getOperate() + SqlAssistant.resolveSqlParameter(columnMeta);
    }

    public static String resolveMethodType(String methodName) {
        if (methodName.startsWith("insertSelective")) {
            return "insertSelective";
        }
        if (methodName.startsWith("insert")) {
            return "insert";
        }
        if (methodName.startsWith("batchInsert")) {
            return "batchInsert";
        }
        if (methodName.startsWith("delete")) {
            return "delete";
        }
        if (methodName.startsWith("updateSelective")) {
            return "updateSelective";
        }
        if (methodName.startsWith("update")) {
            return "update";
        }
        if (methodName.startsWith("batchUpdate")) {
            return "batchUpdate";
        }
        if (methodName.startsWith("selectPage")) {
            return "selectPage";
        }
        if (methodName.startsWith("select")) {
            return "select";
        }
        return null;
    }

    private static OperateEnum resolveOperate(String expression) {
        OperateEnum[] enums;
        for (OperateEnum operate : enums = OperateEnum.values()) {
            if (!expression.endsWith(operate.getAlias())) continue;
            return operate;
        }
        return OperateEnum.EQUAL;
    }

    public static final String resolveSqlParameter(MybatisColumnMeta columnMeta) {
        return SqlAssistant.resolveSqlParameter(columnMeta, "");
    }

    public static final String resolveSqlParameter(MybatisColumnMeta columnMeta, String alias) {
        String sqlParameter = "#{";
        if (alias != null && !"".equals(alias)) {
            sqlParameter = sqlParameter + alias + ".";
        }
        sqlParameter = sqlParameter + columnMeta.getProperty();
        if (columnMeta.getJdbcTypeAlias() != null) {
            sqlParameter = sqlParameter + ", jdbcType=" + columnMeta.getJdbcTypeAlias();
        }
        if (columnMeta.getTypeHandlerClass() != null) {
            sqlParameter = sqlParameter + ", typeHandler=" + columnMeta.getTypeHandlerClass().getName();
        }
        sqlParameter = sqlParameter + "} ";
        return sqlParameter;
    }
}

