/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

final class DefaultOpenOptions
extends AbstractSet<OpenOption> {
    static final Set<OpenOption> INSTANCE = new DefaultOpenOptions();

    private DefaultOpenOptions() {
    }

    @Override
    public Iterator<OpenOption> iterator() {
        return new DefaultOpenOptionsIterator();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return o == StandardOpenOption.CREATE || o == StandardOpenOption.TRUNCATE_EXISTING || o == StandardOpenOption.WRITE;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return 3;
    }

    static final class DefaultOpenOptionsIterator
    implements Iterator<OpenOption> {
        private int index = 0;

        DefaultOpenOptionsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < 3;
        }

        @Override
        public OpenOption next() {
            ++this.index;
            switch (this.index) {
                case 1: {
                    return StandardOpenOption.CREATE;
                }
                case 2: {
                    return StandardOpenOption.TRUNCATE_EXISTING;
                }
                case 3: {
                    return StandardOpenOption.WRITE;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

