/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.HttpParameter;
import com.github.mjeanroy.junit.servers.client.HttpRequestBody;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyFile;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyFormBuilder;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyMultipartBuilder;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyString;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class HttpRequestBodies {
    private HttpRequestBodies() {
    }

    public static HttpRequestBody requestBody(String body) {
        return HttpRequestBodyString.of(body);
    }

    public static HttpRequestBody jsonBody(String body) {
        return HttpRequestBodyString.of(body, "application/json");
    }

    public static HttpRequestBody xmlBody(String body) {
        return HttpRequestBodyString.of(body, "application/xml");
    }

    public static HttpRequestBody textBody(String body) {
        return HttpRequestBodyString.of(body, "text/plain");
    }

    public static HttpRequestBody fileBody(File file) {
        return HttpRequestBodyFile.of(file);
    }

    public static HttpRequestBody jpeg(File file) {
        return HttpRequestBodyFile.of(file, "image/jpeg");
    }

    public static HttpRequestBody jpeg(Path path) {
        return HttpRequestBodyFile.of(path, "image/jpeg");
    }

    public static HttpRequestBody png(File file) {
        return HttpRequestBodyFile.of(file, "image/png");
    }

    public static HttpRequestBody png(Path path) {
        return HttpRequestBodyFile.of(path, "image/png");
    }

    public static HttpRequestBody pdf(File file) {
        return HttpRequestBodyFile.of(file, "application/pdf");
    }

    public static HttpRequestBody pdf(Path path) {
        return HttpRequestBodyFile.of(path, "application/pdf");
    }

    public static HttpRequestBody fileBody(File file, String contentType) {
        return HttpRequestBodyFile.of(file, contentType);
    }

    public static HttpRequestBody fileBody(Path path) {
        return HttpRequestBodyFile.of(path);
    }

    public static HttpRequestBody fileBody(Path path, String contentType) {
        return HttpRequestBodyFile.of(path, contentType);
    }

    public static HttpRequestBody formUrlEncodedBody(Map<String, String> parameters) {
        return new HttpRequestBodyFormBuilder().addAll(parameters).build();
    }

    public static HttpRequestBody formUrlEncodedBody(Collection<HttpParameter> parameters) {
        return new HttpRequestBodyFormBuilder().addAll(parameters).build();
    }

    public static HttpRequestBody formUrlEncodedBody(HttpParameter parameter, HttpParameter ... others) {
        ArrayList<HttpParameter> parameters = new ArrayList<HttpParameter>(others.length + 1);
        parameters.add(parameter);
        Collections.addAll(parameters, others);
        return new HttpRequestBodyFormBuilder().addAll(parameters).build();
    }

    public static HttpRequestBodyFormBuilder formBuilder() {
        return new HttpRequestBodyFormBuilder();
    }

    public static HttpRequestBodyMultipartBuilder multipartBuilder() {
        return new HttpRequestBodyMultipartBuilder();
    }
}

