/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.HttpParameter;
import com.github.mjeanroy.junit.servers.client.HttpRequestBody;
import com.github.mjeanroy.junit.servers.commons.io.Ios;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class HttpRequestBodyForm
implements HttpRequestBody {
    private final List<HttpParameter> parameters;

    HttpRequestBodyForm(Collection<HttpParameter> parameters) {
        this.parameters = Collections.unmodifiableList(new ArrayList<HttpParameter>(parameters));
    }

    @Override
    public String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    @Override
    public byte[] getBody() {
        ArrayList<String> rawParameters = new ArrayList<String>(this.parameters.size());
        for (HttpParameter parameter : this.parameters) {
            rawParameters.add(parameter.asEncodedString());
        }
        String rawBody = String.join((CharSequence)"&", rawParameters);
        return Ios.toUtf8Bytes(rawBody);
    }

    public Collection<HttpParameter> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("parameters", this.parameters).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRequestBodyForm) {
            HttpRequestBodyForm b = (HttpRequestBodyForm)o;
            return Objects.equals(this.parameters, b.parameters);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }
}

