/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.HttpParameter;
import com.github.mjeanroy.junit.servers.client.HttpRequestBody;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyForm;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class HttpRequestBodyFormBuilder {
    private final Map<String, HttpParameter> parameters = new LinkedHashMap<String, HttpParameter>();

    HttpRequestBodyFormBuilder() {
    }

    public HttpRequestBodyFormBuilder add(HttpParameter parameter) {
        Preconditions.notNull(parameter, "HTTP Parameter must not be null");
        return this.doAddAll(Collections.singleton(parameter));
    }

    public HttpRequestBodyFormBuilder add(String name, String value) {
        return this.add(HttpParameter.of(name, value));
    }

    public HttpRequestBodyFormBuilder addAll(Map<String, String> parameters) {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(parameters.size());
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            params.add(HttpParameter.of(parameter.getKey(), parameter.getValue()));
        }
        return this.doAddAll(params);
    }

    public HttpRequestBodyFormBuilder addAll(Collection<HttpParameter> parameters) {
        return this.doAddAll(parameters);
    }

    private HttpRequestBodyFormBuilder doAddAll(Collection<HttpParameter> parameters) {
        Preconditions.doesNotContainNull(parameters, "parameters");
        for (HttpParameter parameter : parameters) {
            this.parameters.put(parameter.getName(), parameter);
        }
        return this;
    }

    public HttpRequestBody build() {
        return new HttpRequestBodyForm(this.parameters.values());
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("parameters", this.parameters).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRequestBodyFormBuilder) {
            HttpRequestBodyFormBuilder b = (HttpRequestBodyFormBuilder)o;
            return Objects.equals(this.parameters, b.parameters);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }
}

