/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpRequestBody;
import com.github.mjeanroy.junit.servers.commons.io.Ios;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.Strings;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class HttpRequestBodyPart {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestBodyPart.class);
    private final Map<String, HttpHeader> headers;
    private final HttpRequestBody body;

    static HttpRequestBodyPart of(HttpRequestBody body) {
        Preconditions.notNull(body, "body");
        return new HttpRequestBodyPart(body, Collections.emptyList());
    }

    static HttpRequestBodyPart of(HttpRequestBody body, Collection<HttpHeader> headers) {
        Preconditions.notNull(body, "body");
        Preconditions.doesNotContainNull(headers, "headers");
        return new HttpRequestBodyPart(body, headers);
    }

    static HttpRequestBodyPart of(HttpRequestBody body, HttpHeader header) {
        Preconditions.notNull(body, "body");
        Preconditions.notNull(header, "header");
        return new HttpRequestBodyPart(body, Collections.singleton(header));
    }

    private HttpRequestBodyPart(HttpRequestBody body, Collection<HttpHeader> headers) {
        LinkedHashMap<String, HttpHeader> map = new LinkedHashMap<String, HttpHeader>();
        for (HttpHeader header : headers) {
            map.put(header.getName().toLowerCase(), header);
        }
        this.body = body;
        this.headers = Collections.unmodifiableMap(map);
    }

    byte[] serialize() throws IOException {
        log.debug("Writing part body");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (HttpHeader header : this.headers.values()) {
            log.debug("Writing header: {}", header);
            bos.write(Ios.toUtf8Bytes(header.serialize()));
            bos.write(Ios.CRLF);
        }
        String contentType = this.body.getContentType();
        if (Strings.isNotEmpty(contentType)) {
            log.debug("Writing content type: {}", contentType);
            bos.write(Ios.toUtf8Bytes(HttpHeader.header("Content-Type", this.body.getContentType()).serialize()));
            bos.write(Ios.CRLF);
        }
        log.debug("Writing body: {}", this.body);
        bos.write(Ios.CRLF);
        bos.write(this.body.getBody());
        return bos.toByteArray();
    }

    HttpRequestBody getBody() {
        return this.body;
    }

    Collection<HttpHeader> getHeaders() {
        return this.headers.values();
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("headers", this.headers).append("body", this.body).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRequestBodyPart) {
            HttpRequestBodyPart b = (HttpRequestBodyPart)o;
            return Objects.equals(this.headers, b.headers) && Objects.equals(this.body, b.body);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.body);
    }
}

