/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.commons.core.Urls;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.exceptions.UrlException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HttpUrl {
    private static final HttpScheme DEFAULT_SCHEME = HttpScheme.HTTP;
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PATH = "/";
    private static final String SCHEME_SEPARATOR = "://";
    private static final String PORT_SEPARATOR = ":";
    private final HttpScheme scheme;
    private final String host;
    private final int port;
    private final String path;

    public static HttpUrl parse(String endpoint) {
        try {
            URL url = new URL(endpoint);
            String protocol = url.getProtocol();
            String host = url.getHost();
            int port = url.getPort();
            String path = url.getPath();
            return new Builder().withScheme(protocol).withHost(host).withPort(port >= 0 ? port : url.getDefaultPort()).withPath(path).build();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private HttpUrl(HttpScheme scheme, String host, int port, String path) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public String getScheme() {
        return this.scheme.getProtocol();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public URI toURI() {
        String protocol = this.scheme.getProtocol();
        try {
            return new URI(protocol, null, this.host, this.port, this.path, null, null);
        }
        catch (URISyntaxException ex) {
            throw new UrlException(protocol, this.host, this.port, this.path, ex);
        }
    }

    public String toString() {
        String protocol = this.scheme.getProtocol();
        String port = String.valueOf(this.port);
        int size = protocol.length() + this.host.length() + port.length() + this.path.length() + SCHEME_SEPARATOR.length() + PORT_SEPARATOR.length();
        return new StringBuilder(size).append(protocol).append(SCHEME_SEPARATOR).append(this.host).append(PORT_SEPARATOR).append(port).append(this.path).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpUrl) {
            HttpUrl u = (HttpUrl)o;
            return Objects.equals((Object)this.scheme, (Object)u.scheme) && Objects.equals(this.host, u.host) && Objects.equals(this.port, u.port) && Objects.equals(this.path, u.path);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scheme, this.host, this.port, this.path});
    }

    private static enum HttpScheme {
        HTTP("http", 80),
        HTTPS("https", 443);

        private final String protocol;
        private final int defaultPort;
        private static final Map<String, HttpScheme> VALUES;

        private HttpScheme(String protocol, int defaultPort) {
            this.protocol = protocol;
            this.defaultPort = defaultPort;
        }

        private int getDefaultPort() {
            return this.defaultPort;
        }

        private String getProtocol() {
            return this.protocol;
        }

        private static HttpScheme parse(String protocol) {
            return VALUES.get(protocol.toLowerCase());
        }

        static {
            HashMap<String, HttpScheme> values = new HashMap<String, HttpScheme>();
            values.put(HTTP.getProtocol(), HTTP);
            values.put(HTTPS.getProtocol(), HTTPS);
            VALUES = Collections.unmodifiableMap(values);
        }
    }

    public static class Builder {
        private HttpScheme scheme;
        private String host;
        private Integer port;
        private String path;

        public Builder withScheme(String scheme) {
            Preconditions.notNull(scheme, "scheme");
            HttpScheme result = HttpScheme.parse(scheme);
            if (result == null) {
                throw new IllegalArgumentException(String.format("Unknown scheme: %s", scheme));
            }
            this.scheme = result;
            return this;
        }

        public Builder withHost(String host) {
            this.host = Preconditions.notNull(host, "host");
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withPath(String path) {
            this.path = Preconditions.notNull(path, "path");
            return this;
        }

        public HttpUrl build() {
            HttpScheme scheme = com.github.mjeanroy.junit.servers.commons.lang.Objects.firstNonNull(this.scheme, DEFAULT_SCHEME);
            String host = com.github.mjeanroy.junit.servers.commons.lang.Objects.firstNonNull(this.host, HttpUrl.DEFAULT_HOST);
            String path = com.github.mjeanroy.junit.servers.commons.lang.Objects.firstNonNull(this.path, HttpUrl.DEFAULT_PATH);
            int port = com.github.mjeanroy.junit.servers.commons.lang.Objects.firstNonNull(this.port, scheme.getDefaultPort());
            return new HttpUrl(scheme, host, port, Urls.ensureAbsolutePath(path));
        }
    }
}

