/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl;

import com.github.mjeanroy.junit.servers.client.Cookie;
import com.github.mjeanroy.junit.servers.client.Cookies;
import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpResponse;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.exceptions.HttpClientException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractHttpResponse
implements HttpResponse {
    private final long duration;
    private final Lock readResponseBodyLock;
    private String _body;

    protected AbstractHttpResponse(long duration) {
        this.duration = Preconditions.positive(duration, "Duration must be positive");
        this.readResponseBodyLock = new ReentrantLock();
    }

    @Override
    public long getRequestDuration() {
        return this.duration;
    }

    @Override
    public long getRequestDurationInMillis() {
        return this.getRequestDuration() / 1000L / 1000L;
    }

    @Override
    public String body() {
        this.readResponseBodyLock.lock();
        try {
            this.readBodyIfNotAlreadyComputed();
            String string = this._body;
            return string;
        }
        catch (IOException ex) {
            throw new HttpClientException(ex);
        }
        finally {
            this.readResponseBodyLock.unlock();
        }
    }

    private void readBodyIfNotAlreadyComputed() throws IOException {
        if (this._body == null) {
            this._body = this.readResponseBody();
        }
    }

    protected abstract String readResponseBody() throws IOException;

    @Override
    public boolean containsHeader(String name) {
        return this.getHeader(name) != null;
    }

    @Override
    public Cookie getCookie(String name) {
        Preconditions.notBlank(name, "name");
        HttpHeader header = this.getHeader("Set-Cookie");
        if (header == null) {
            return null;
        }
        for (String value : header.getValues()) {
            Cookie cookie = Cookies.read(value);
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    @Override
    public List<Cookie> getCookies() {
        HttpHeader header = this.getHeader("Set-Cookie");
        if (header == null) {
            return Collections.emptyList();
        }
        List<String> values = header.getValues();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(values.size());
        for (String value : values) {
            cookies.add(Cookies.read(value));
        }
        return Collections.unmodifiableList(cookies);
    }

    @Override
    public HttpHeader getETag() {
        return this.getHeader("ETag");
    }

    @Override
    public HttpHeader getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public HttpHeader getContentEncoding() {
        return this.getHeader("Content-Encoding");
    }

    @Override
    public HttpHeader getLocation() {
        return this.getHeader("Location");
    }

    @Override
    public HttpHeader getCacheControl() {
        return this.getHeader("Cache-Control");
    }

    @Override
    public HttpHeader getLastModified() {
        return this.getHeader("Last-Modified");
    }

    @Override
    public HttpHeader getStrictTransportSecurity() {
        return this.getHeader("Strict-Transport-Security");
    }

    @Override
    public HttpHeader getContentSecurityPolicy() {
        return this.getHeader("Content-Security-Policy");
    }

    @Override
    public HttpHeader getXContentSecurityPolicy() {
        return this.getHeader("X-Content-Security-Policy");
    }

    @Override
    public HttpHeader getXWebkitCSP() {
        return this.getHeader("X-Webkit-CSP");
    }

    @Override
    public HttpHeader getXContentTypeOptions() {
        return this.getHeader("X-Content-Type-Options");
    }

    @Override
    public HttpHeader getXXSSProtection() {
        return this.getHeader("X-XSS-Protection");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractHttpResponse) {
            AbstractHttpResponse r = (AbstractHttpResponse)o;
            return r.canEqual(this) && Objects.equals(this.duration, r.duration);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.duration);
    }

    protected boolean canEqual(AbstractHttpResponse o) {
        return true;
    }
}

