/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.okhttp3;

import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpResponse;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import okhttp3.Headers;

final class OkHttpResponse
extends AbstractHttpResponse {
    private final int code;
    private final String body;
    private final Headers headers;

    OkHttpResponse(int code, String body, Headers headers, long duration) {
        super(duration);
        this.code = code;
        this.body = body;
        this.headers = Preconditions.notNull(headers, "Headers");
    }

    @Override
    public int status() {
        return this.code;
    }

    @Override
    protected String readResponseBody() {
        return this.body;
    }

    @Override
    public Collection<HttpHeader> getHeaders() {
        int size = this.headers.size();
        ArrayList<HttpHeader> results = new ArrayList<HttpHeader>(size);
        for (String name : this.headers.names()) {
            results.add(HttpHeader.header(name, this.headers.values(name)));
        }
        return results;
    }

    @Override
    public HttpHeader getHeader(String name) {
        List values = this.headers.values(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return HttpHeader.header(name, values);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("duration", this.getRequestDuration()).append("code", this.code).append("body", this.body).append("headers", this.headers).build();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OkHttpResponse) {
            OkHttpResponse r = (OkHttpResponse)o;
            return super.equals(r) && Objects.equals(this.code, r.code) && Objects.equals(this.body, r.body) && Objects.equals(this.headers, r.headers);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.code, this.body, this.headers);
    }

    @Override
    protected boolean canEqual(AbstractHttpResponse o) {
        return o instanceof OkHttpResponse;
    }
}

