/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons.io;

import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class Ios {
    private static final Logger log = LoggerFactory.getLogger(Ios.class);
    public static final byte[] CRLF = Ios.toUtf8Bytes("\r\n");

    private Ios() {
    }

    public static byte[] toUtf8Bytes(String value) {
        if (value == null) {
            return new byte[0];
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] toBytes(Path path) throws IOException {
        if (path == null) {
            return new byte[0];
        }
        return Files.readAllBytes(path);
    }

    public static String guessContentType(Path path) {
        if (path == null) {
            return null;
        }
        log.debug("Try to guess content type of path: {}", path);
        String mimeType = Ios.tryProbeContentType(path);
        if (mimeType == null) {
            mimeType = Ios.tryGuessContentTypeFromStream(path);
        }
        if (mimeType == null) {
            mimeType = Ios.tryGuessContentTypeFromFileName(path);
        }
        return mimeType;
    }

    private static String tryProbeContentType(Path path) {
        try {
            return Files.probeContentType(path);
        }
        catch (IOException ex) {
            log.warn(ex.getMessage(), ex);
            return null;
        }
    }

    private static String tryGuessContentTypeFromStream(Path path) {
        String string;
        BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        try {
            string = URLConnection.guessContentTypeFromStream(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                log.warn(ex.getMessage(), ex);
                return null;
            }
        }
        ((InputStream)is).close();
        return string;
    }

    private static String tryGuessContentTypeFromFileName(Path path) {
        return URLConnection.guessContentTypeFromName(path.getFileName().toString());
    }
}

