/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.engine;

import com.github.mjeanroy.junit.servers.annotations.TestHttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClientStrategy;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.commons.reflect.Annotations;
import com.github.mjeanroy.junit.servers.commons.reflect.Reflections;
import com.github.mjeanroy.junit.servers.engine.AbstractAnnotationHandler;
import com.github.mjeanroy.junit.servers.engine.AnnotationHandler;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.lang.reflect.Field;

class HttpClientAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(HttpClientAnnotationHandler.class);
    private final EmbeddedServer<?> server;

    static AnnotationHandler newHttpClientAnnotationHandler(EmbeddedServer<?> server) {
        return new HttpClientAnnotationHandler(Preconditions.notNull(server, "server"));
    }

    private HttpClientAnnotationHandler(EmbeddedServer<?> server) {
        super(TestHttpClient.class);
        this.server = server;
    }

    @Override
    public void before(Object target, Field field) {
        log.debug("Inject HTTP client to {} # {}", target, field);
        TestHttpClient httpClient = Annotations.findAnnotation(field, TestHttpClient.class);
        if (httpClient != null) {
            HttpClientStrategy strategy = httpClient.strategy();
            Reflections.setter(target, field, strategy.build(this.server));
        }
    }

    @Override
    public void after(Object target, Field field) {
        log.debug("Clearing HTTP client to {} # {}", target, field);
        HttpClient httpClient = (HttpClient)Reflections.getter(target, field);
        httpClient.destroy();
        Reflections.setter(target, field, null);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("annotationKlass", this.getAnnotationKlass()).append("server", this.server).build();
    }
}

