/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.engine;

import com.github.mjeanroy.junit.servers.annotations.TestServer;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.commons.reflect.Reflections;
import com.github.mjeanroy.junit.servers.engine.AbstractAnnotationHandler;
import com.github.mjeanroy.junit.servers.engine.AnnotationHandler;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.lang.reflect.Field;

class ServerAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(ServerAnnotationHandler.class);
    private final EmbeddedServer<?> server;

    static AnnotationHandler newServerAnnotationHandler(EmbeddedServer<?> server) {
        return new ServerAnnotationHandler(Preconditions.notNull(server, "server"));
    }

    private ServerAnnotationHandler(EmbeddedServer<?> server) {
        super(TestServer.class);
        this.server = server;
    }

    @Override
    public void before(Object target, Field field) {
        log.debug("Injecting embedded server to {} # {}", target, field);
        Reflections.setter(target, field, this.server);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("annotationKlass", this.getAnnotationKlass()).append("server", this.server).build();
    }
}

