/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jupiter;

import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.engine.AnnotationsHandlerRunner;
import com.github.mjeanroy.junit.servers.engine.EmbeddedServerRunner;
import com.github.mjeanroy.junit.servers.engine.Servers;
import com.github.mjeanroy.junit.servers.jupiter.ConfigurationResolverFunction;
import com.github.mjeanroy.junit.servers.jupiter.EmbeddedServerParameterResolverFunction;
import com.github.mjeanroy.junit.servers.jupiter.HttpClientParameterResolverFunction;
import com.github.mjeanroy.junit.servers.jupiter.ParameterResolverFunction;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class JunitServerExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final Logger log = LoggerFactory.getLogger(JunitServerExtension.class);
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{JunitServerExtension.class.getName()});
    private static final String SERVER_RUNNER_KEY = "serverAdapter";
    private static final String SERVER_RUNNER_STATIC_MODE = "serverAdapterMode";
    private static final String ANNOTATIONS_RUNNER_KEY = "annotationsAdapter";
    private static final Map<Class<?>, ParameterResolverFunction> RESOLVERS = new HashMap();
    private final EmbeddedServer<?> server;
    private final AbstractConfiguration configuration;

    public JunitServerExtension() {
        this.server = null;
        this.configuration = null;
    }

    public JunitServerExtension(EmbeddedServer<?> server) {
        this.server = Preconditions.notNull(server, "server");
        this.configuration = null;
    }

    public JunitServerExtension(AbstractConfiguration configuration) {
        this.server = null;
        this.configuration = configuration;
    }

    public void beforeAll(ExtensionContext context) {
        this.registerEmbeddedServer(context, true);
    }

    public void afterAll(ExtensionContext context) {
        this.unregisterEmbeddedServer(context, true);
    }

    public void beforeEach(ExtensionContext context) {
        EmbeddedServerRunner serverAdapter = JunitServerExtension.findEmbeddedServerAdapterInStore(context);
        if (serverAdapter == null) {
            serverAdapter = this.registerEmbeddedServer(context, false);
        }
        EmbeddedServer<?> server = serverAdapter.getServer();
        Object configuration = server.getConfiguration();
        AnnotationsHandlerRunner annotationsAdapter = new AnnotationsHandlerRunner(server, (AbstractConfiguration)configuration);
        annotationsAdapter.beforeEach(context.getRequiredTestInstance());
        JunitServerExtension.putAnnotationsHandlerAdapterInStore(context, annotationsAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterEach(ExtensionContext context) {
        try {
            Object target = context.getRequiredTestInstance();
            AnnotationsHandlerRunner annotationsAdapter = JunitServerExtension.findAnnotationsHandlerAdapterInStore(context);
            annotationsAdapter.afterEach(target);
        }
        finally {
            this.unregisterEmbeddedServer(context, false);
            JunitServerExtension.removeAnnotationsHandlerAdapterFromStore(context);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        Class<?> parameterClass = parameter.getType();
        if (RESOLVERS.containsKey(parameterClass)) {
            return true;
        }
        for (Class<?> klass : RESOLVERS.keySet()) {
            if (!klass.isAssignableFrom(parameterClass)) continue;
            return true;
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        Class<?> parameterClass = parameter.getType();
        EmbeddedServerRunner serverAdapter = JunitServerExtension.findEmbeddedServerAdapterInStore(extensionContext);
        if (RESOLVERS.containsKey(parameterClass)) {
            return RESOLVERS.get(parameterClass).resolve(parameterContext, serverAdapter);
        }
        for (Class<?> klass : RESOLVERS.keySet()) {
            if (!klass.isAssignableFrom(parameterClass)) continue;
            return RESOLVERS.get(klass).resolve(parameterContext, serverAdapter);
        }
        return null;
    }

    protected EmbeddedServer<?> instantiateServer(Class<?> testClass, AbstractConfiguration configuration) {
        log.debug("Instantiating embedded server for test class: {}", testClass);
        return configuration == null ? Servers.instantiate(testClass) : Servers.instantiate(configuration);
    }

    private EmbeddedServerRunner registerEmbeddedServer(ExtensionContext context, boolean staticMode) {
        log.debug("Register embedded server to junit extension context");
        Class testClass = context.getRequiredTestClass();
        EmbeddedServer<?> server = this.server == null ? this.instantiateServer(testClass, this.configuration) : this.server;
        EmbeddedServerRunner serverAdapter = new EmbeddedServerRunner(server);
        serverAdapter.beforeAll();
        JunitServerExtension.putEmbeddedServerAdapterInStore(context, serverAdapter, staticMode);
        return serverAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterEmbeddedServer(ExtensionContext context, boolean staticMode) {
        log.debug("Attempt to unregister embedded server to junit extension context");
        boolean registeredAsStatic = (Boolean)JunitServerExtension.findInStore(context, SERVER_RUNNER_STATIC_MODE);
        if (registeredAsStatic == staticMode) {
            try {
                EmbeddedServerRunner serverAdapter = JunitServerExtension.findEmbeddedServerAdapterInStore(context);
                serverAdapter.afterAll();
            }
            finally {
                JunitServerExtension.removeEmbeddedServerAdapterFromStore(context);
            }
        }
    }

    private static EmbeddedServerRunner findEmbeddedServerAdapterInStore(ExtensionContext context) {
        return (EmbeddedServerRunner)JunitServerExtension.findInStore(context, SERVER_RUNNER_KEY);
    }

    private static void putEmbeddedServerAdapterInStore(ExtensionContext context, EmbeddedServerRunner serverAdapter, boolean staticMode) {
        log.debug("Store embedded server to junit extension context");
        JunitServerExtension.putInStore(context, SERVER_RUNNER_KEY, serverAdapter);
        JunitServerExtension.putInStore(context, SERVER_RUNNER_STATIC_MODE, staticMode);
    }

    private static void removeEmbeddedServerAdapterFromStore(ExtensionContext context) {
        log.debug("Clearing junit extension context");
        JunitServerExtension.removeFromStore(context, SERVER_RUNNER_KEY);
        JunitServerExtension.removeFromStore(context, SERVER_RUNNER_STATIC_MODE);
    }

    private static AnnotationsHandlerRunner findAnnotationsHandlerAdapterInStore(ExtensionContext context) {
        return (AnnotationsHandlerRunner)JunitServerExtension.findInStore(context, ANNOTATIONS_RUNNER_KEY);
    }

    private static void putAnnotationsHandlerAdapterInStore(ExtensionContext context, AnnotationsHandlerRunner annotationsHandlerAdapter) {
        JunitServerExtension.putInStore(context, ANNOTATIONS_RUNNER_KEY, annotationsHandlerAdapter);
    }

    private static void removeAnnotationsHandlerAdapterFromStore(ExtensionContext context) {
        JunitServerExtension.removeFromStore(context, ANNOTATIONS_RUNNER_KEY);
    }

    private static <T> void putInStore(ExtensionContext context, String name, T value) {
        log.trace("Put to junit extension context: {} -> {}", name, value);
        JunitServerExtension.getStore(context).put((Object)name, value);
    }

    private static <T> T findInStore(ExtensionContext context, String name) {
        log.trace("Looking for {} entry in junit extension context", name);
        return (T)JunitServerExtension.getStore(context).get((Object)name);
    }

    private static void removeFromStore(ExtensionContext context, String name) {
        log.trace("Remove to junit extension context: {}", name);
        JunitServerExtension.getStore(context).remove((Object)name);
    }

    private static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(NAMESPACE);
    }

    static {
        RESOLVERS.put(EmbeddedServer.class, EmbeddedServerParameterResolverFunction.getInstance());
        RESOLVERS.put(AbstractConfiguration.class, ConfigurationResolverFunction.getInstance());
        RESOLVERS.put(HttpClient.class, HttpClientParameterResolverFunction.getInstance());
    }
}

