/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.loggers;

import com.github.mjeanroy.junit.servers.commons.reflect.Classes;
import com.github.mjeanroy.junit.servers.loggers.Log4jLogger;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.NoOpLogger;
import com.github.mjeanroy.junit.servers.loggers.Slf4jLogger;

public final class LoggerFactory {
    private static final boolean SLF4J_AVAILABLE = Classes.isPresent("org.slf4j.LoggerFactory");
    private static final boolean LOG4J2_AVAILABLE = Classes.isPresent("org.apache.logging.log4j.Logger");

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> klass) {
        if (SLF4J_AVAILABLE) {
            return new Slf4jLogger(klass);
        }
        if (LOG4J2_AVAILABLE) {
            return new Log4jLogger(klass);
        }
        return new NoOpLogger();
    }
}

