/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.tomcat;

import com.github.mjeanroy.junit.servers.commons.reflect.Annotations;
import com.github.mjeanroy.junit.servers.commons.reflect.Classes;
import com.github.mjeanroy.junit.servers.engine.Servers;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.tomcat.AbstractEmbeddedTomcat;
import com.github.mjeanroy.junit.servers.tomcat.EmbeddedTomcatConfiguration;
import com.github.mjeanroy.junit.servers.tomcat.EmbeddedTomcatConfigurationProvider;
import com.github.mjeanroy.junit.servers.tomcat.IllegalTomcatConfigurationException;
import com.github.mjeanroy.junit.servers.tomcat.TomcatConfiguration;

public abstract class AbstractEmbeddedTomcatFactory<EMBEDDED_TOMCAT extends AbstractEmbeddedTomcat<EmbeddedTomcatConfiguration>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractEmbeddedTomcatFactory.class);

    public final EMBEDDED_TOMCAT instantiateFrom(Class<?> testClass) {
        return this.instantiateFrom(testClass, null);
    }

    public final EMBEDDED_TOMCAT instantiateFrom(Class<?> testClass, EmbeddedTomcatConfiguration configuration) {
        log.debug("Instantiating embedded tomcat for test class: {}", testClass);
        EmbeddedTomcatConfiguration configurationToUse = this.extractConfiguration(testClass, configuration);
        return configurationToUse == null ? this.instantiateFrom() : this.instantiateFrom(configurationToUse);
    }

    protected abstract EMBEDDED_TOMCAT instantiateFrom();

    protected abstract EMBEDDED_TOMCAT instantiateFrom(EmbeddedTomcatConfiguration var1);

    private EmbeddedTomcatConfiguration extractConfiguration(Class<?> testClass, EmbeddedTomcatConfiguration configuration) {
        if (configuration != null) {
            log.debug("Returning provided configuration instance: {}", configuration);
            return this.checkConfiguration(configuration);
        }
        Class<EmbeddedTomcatConfigurationProvider> providerClass = this.findEmbeddedTomcatConfigurationProvider(testClass);
        if (providerClass != null) {
            return this.buildEmbeddedTomcatConfiguration(testClass, providerClass);
        }
        log.debug("Extracting configuration from given test class: {}", testClass);
        return this.checkConfiguration(Servers.findConfiguration(testClass));
    }

    private Class<? extends EmbeddedTomcatConfigurationProvider> findEmbeddedTomcatConfigurationProvider(Class<?> testClass) {
        TomcatConfiguration configurationAnnotation = Annotations.findAnnotation(testClass, TomcatConfiguration.class);
        return configurationAnnotation == null ? null : configurationAnnotation.providedBy();
    }

    private EmbeddedTomcatConfiguration buildEmbeddedTomcatConfiguration(Class<?> testClass, Class<? extends EmbeddedTomcatConfigurationProvider> providerClass) {
        log.debug("Returning configuration provided by test class");
        EmbeddedTomcatConfigurationProvider provider = Classes.instantiate(providerClass);
        return provider.build(testClass);
    }

    private EmbeddedTomcatConfiguration checkConfiguration(Object configuration) {
        if (configuration == null) {
            return null;
        }
        if (!(configuration instanceof EmbeddedTomcatConfiguration)) {
            log.error("Cannot instantiate embedded tomcat using configuration {} because it does not extends {} class", configuration, EmbeddedTomcatConfiguration.class);
            throw new IllegalTomcatConfigurationException(EmbeddedTomcatConfiguration.class);
        }
        return (EmbeddedTomcatConfiguration)configuration;
    }
}

