/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.commons.core.Encoders;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.Strings;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import java.util.Objects;

public class HttpParameter {
    private final String name;
    private final String value;

    public static HttpParameter of(String name, String value) {
        return HttpParameter.param(name, value);
    }

    public static HttpParameter param(String name, String value) {
        return new HttpParameter(name, value);
    }

    private HttpParameter(String name, String value) {
        this.name = Preconditions.notBlank(name, "name");
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getEncodedName() {
        return Encoders.urlEncode(this.name);
    }

    public String getEncodedValue() {
        return this.value == null ? null : Encoders.urlEncode(this.value);
    }

    public String asEncodedString() {
        return Encoders.urlEncode(this.name) + "=" + Encoders.urlEncode(Strings.nullToEmpty(this.value));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpParameter) {
            HttpParameter p = (HttpParameter)o;
            return Objects.equals(this.name, p.name) && Objects.equals(this.value, p.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("name", this.name).append("value", this.value).build();
    }
}

