/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.HttpRequestBody;
import com.github.mjeanroy.junit.servers.client.HttpRequestBodyPart;
import com.github.mjeanroy.junit.servers.commons.io.Ios;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class HttpRequestBodyMultipart
implements HttpRequestBody {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestBodyMultipart.class);
    private static final byte[] DASH_DASH = Ios.toUtf8Bytes("--");
    private static final String DEFAULT_BOUNDARIES = "---------------------------974767299852498929531610575";
    private final String contentType;
    private final String boundaries;
    private final List<HttpRequestBodyPart> parts;

    HttpRequestBodyMultipart(String contentType, String boundaries, Collection<HttpRequestBodyPart> parts) {
        this.contentType = com.github.mjeanroy.junit.servers.commons.lang.Objects.firstNonNull(contentType, "multipart/form-data");
        this.boundaries = com.github.mjeanroy.junit.servers.commons.lang.Objects.firstNonNull(boundaries, DEFAULT_BOUNDARIES);
        this.parts = Collections.unmodifiableList(new ArrayList<HttpRequestBodyPart>(parts));
    }

    @Override
    public String getContentType() {
        return this.contentType + "; boundary=" + this.boundaries;
    }

    @Override
    public byte[] getBody() throws IOException {
        log.debug("Generating multipart body");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (HttpRequestBodyPart bodyPart : this.parts) {
            log.debug("Writing part: {}", bodyPart);
            log.debug("Use boundary: {}", this.boundaries);
            bos.write(DASH_DASH);
            bos.write(Ios.toUtf8Bytes(this.boundaries));
            bos.write(Ios.CRLF);
            bos.write(bodyPart.serialize());
            bos.write(Ios.CRLF);
        }
        log.debug("Writing last boundaries: {}", this.boundaries);
        bos.write(DASH_DASH);
        bos.write(Ios.toUtf8Bytes(this.boundaries));
        return bos.toByteArray();
    }

    String getBoundaries() {
        return this.boundaries;
    }

    List<HttpRequestBodyPart> getParts() {
        return this.parts;
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("contentType", this.contentType).append("boundaries", this.boundaries).append("parts", this.parts).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRequestBodyMultipart) {
            HttpRequestBodyMultipart b = (HttpRequestBodyMultipart)o;
            return Objects.equals(this.contentType, b.contentType) && Objects.equals(this.boundaries, b.boundaries) && Objects.equals(this.parts, b.parts);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.boundaries, this.parts);
    }
}

