/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl;

import com.github.mjeanroy.junit.servers.client.Cookie;
import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClientConfiguration;
import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpRequest;
import com.github.mjeanroy.junit.servers.client.HttpRequestBody;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.commons.core.Urls;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.Strings;
import com.github.mjeanroy.junit.servers.exceptions.HttpClientException;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;

public abstract class AbstractHttpClient
implements HttpClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpClient.class);
    private final HttpClientConfiguration configuration;
    private final EmbeddedServer<?> server;

    protected AbstractHttpClient(HttpClientConfiguration configuration, EmbeddedServer<?> server) {
        this.configuration = Preconditions.notNull(configuration, "configuration");
        this.server = Preconditions.notNull(server, "server");
    }

    @Override
    public HttpClientConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public HttpRequest prepareDelete(String endpoint) {
        return this.prepareRequest(HttpMethod.DELETE, endpoint);
    }

    @Override
    public HttpRequest prepareDelete(String endpoint, HttpRequestBody body) {
        return this.prepareRequest(HttpMethod.DELETE, endpoint).setBody(body);
    }

    @Override
    public HttpRequest prepareGet(String endpoint) {
        return this.prepareRequest(HttpMethod.GET, endpoint);
    }

    @Override
    public HttpRequest preparePost(String endpoint) {
        return this.prepareRequest(HttpMethod.POST, endpoint);
    }

    @Override
    public HttpRequest preparePost(String endpoint, HttpRequestBody body) {
        return this.preparePost(endpoint).setBody(body);
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    @Override
    public HttpRequest preparePut(String url) {
        return this.prepareRequest(HttpMethod.PUT, url);
    }

    @Override
    public HttpRequest preparePut(String url, HttpRequestBody body) {
        return this.preparePut(url).setBody(body);
    }

    @Override
    public HttpRequest preparePatch(String endpoint) {
        return this.prepareRequest(HttpMethod.PATCH, endpoint);
    }

    @Override
    public HttpRequest preparePatch(String endpoint, HttpRequestBody body) {
        return this.preparePatch(endpoint).setBody(body);
    }

    @Override
    public HttpRequest prepareHead(String endpoint) {
        return this.prepareRequest(HttpMethod.HEAD, endpoint);
    }

    @Override
    public HttpRequest prepareRequest(HttpMethod httpMethod, String endpoint) {
        HttpUrl requestEndpoint;
        log.debug("Preparing HTTP request: {} -- {}", (Object)httpMethod, endpoint);
        Preconditions.notNull(endpoint, "endpoint");
        if (this.isDestroyed()) {
            log.error("Attempt to create HTTP request but HTTP client has already been destroyed");
            throw new IllegalStateException("Cannot create request from a destroyed client");
        }
        if (Urls.startsWithHttpScheme(endpoint)) {
            requestEndpoint = HttpUrl.parse(endpoint);
        } else {
            String serverPath = this.server.getPath();
            requestEndpoint = new HttpUrl.Builder().withScheme(this.server.getScheme()).withHost(this.server.getHost()).withPort(this.server.getPort()).withPath(Urls.concatenatePath(serverPath, Strings.removePrefix(endpoint, serverPath))).build();
        }
        HttpRequest rq = this.buildRequest(httpMethod, requestEndpoint);
        log.debug("Adding default headers");
        for (HttpHeader header : this.configuration.getDefaultHeaders().values()) {
            log.trace("Adding default header: {}", header);
            rq = rq.addHeader(header);
        }
        log.debug("Adding default cookies");
        for (Cookie cookie : this.configuration.getDefaultCookies()) {
            log.trace("Adding default cookie: {}", cookie);
            rq = rq.addCookie(cookie);
        }
        return rq;
    }

    @Override
    public void destroy() {
        log.debug("Destroying HTTP client");
        try {
            this.doDestroy();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new HttpClientException(ex);
        }
    }

    protected abstract HttpRequest buildRequest(HttpMethod var1, HttpUrl var2);

    protected abstract void doDestroy() throws Exception;

    protected EmbeddedServer<?> getServer() {
        return this.server;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isDestroyed()) {
            this.destroy();
        }
    }
}

