/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.ning;

import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpResponse;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class NingAsyncHttpResponse
extends AbstractHttpResponse {
    private final Response response;

    NingAsyncHttpResponse(Response response, long duration) {
        super(duration);
        this.response = Preconditions.notNull(response, "Response");
    }

    @Override
    public int status() {
        return this.response.getStatusCode();
    }

    @Override
    protected String readResponseBody() throws IOException {
        return this.response.getResponseBody();
    }

    @Override
    public Collection<HttpHeader> getHeaders() {
        FluentCaseInsensitiveStringsMap headers = this.response.getHeaders();
        ArrayList<HttpHeader> results = new ArrayList<HttpHeader>(headers.size());
        for (Map.Entry entry : headers.entrySet()) {
            results.add(HttpHeader.header((String)entry.getKey(), (Collection)entry.getValue()));
        }
        return results;
    }

    @Override
    public HttpHeader getHeader(String name) {
        List values = this.response.getHeaders(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return HttpHeader.header(name, values);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("duration", this.getRequestDuration()).append("response", this.response).build();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NingAsyncHttpResponse) {
            NingAsyncHttpResponse r = (NingAsyncHttpResponse)o;
            return super.equals(r) && Objects.equals(this.response, r.response);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.response);
    }

    @Override
    protected boolean canEqual(AbstractHttpResponse o) {
        return o instanceof NingAsyncHttpResponse;
    }
}

