/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jetty;

import com.github.mjeanroy.junit.servers.jetty.AbstractBaseEmbeddedJetty;
import com.github.mjeanroy.junit.servers.jetty.AbstractEmbeddedJettyConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public abstract class AbstractEmbeddedJetty<CONFIGURATION extends AbstractEmbeddedJettyConfiguration>
extends AbstractBaseEmbeddedJetty<WebAppContext, CONFIGURATION> {
    protected AbstractEmbeddedJetty(CONFIGURATION configuration) {
        super(configuration);
    }

    @Override
    protected final WebAppContext newWebAppContext() {
        return new WebAppContext();
    }

    @Override
    protected final void setOverrideDescriptor(WebAppContext webAppContext, String overrideDescriptor) {
        webAppContext.setOverrideDescriptor(overrideDescriptor);
    }

    @Override
    protected final void setTempDirectory(WebAppContext webAppContext, String tempDirectory) {
        webAppContext.setTempDirectory(new File(tempDirectory));
    }

    @Override
    protected final void configure(WebAppContext webAppContext) {
        webAppContext.setConfigurations(new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration(), new AnnotationConfiguration(), new JettyWebXmlConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration()});
    }

    @Override
    protected final void setParentLoaderPriority(WebAppContext webAppContext, boolean parentLoaderPriority) {
        webAppContext.setParentLoaderPriority(parentLoaderPriority);
    }

    @Override
    protected final void setWar(WebAppContext webAppContext, Resource war) {
        webAppContext.setWarResource(war);
    }

    @Override
    public final Object getServletContext() {
        WebAppContext webAppContext = (WebAppContext)this.getWebAppContext();
        return webAppContext == null ? null : webAppContext.getServletContext();
    }

    @Override
    protected final void addContainerResources(WebAppContext webAppContext, Resource containerResources) {
        webAppContext.getMetaData().addContainerResource(containerResources);
    }

    @Override
    protected final void setAttribute(WebAppContext webAppContext, String name, String value) {
        webAppContext.setAttribute(this.containerJarPatternPropertyName(), (Object)value);
    }

    @Override
    protected final Resource newResource(WebAppContext webAppContext, String resource) throws IOException {
        return Resource.newResource((String)resource);
    }

    @Override
    protected final Resource newResource(WebAppContext webAppContext, URI resource) throws IOException {
        return Resource.newResource((URI)resource);
    }

    @Override
    protected final void setInitParameter(WebAppContext webAppContext, String name, Object value) {
        webAppContext.setInitParameter(name, String.valueOf(value));
    }
}

