/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jetty;

import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.jetty.AbstractEmbeddedJettyConfigurationBuilder;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import java.util.Objects;
import org.eclipse.jetty.util.resource.Resource;

abstract class AbstractEmbeddedJettyConfiguration
extends AbstractConfiguration {
    static final int DEFAULT_STOP_TIMEOUT = 30000;
    static final boolean DEFAULT_STOP_AT_SHUTDOWN = true;
    private final int stopTimeout;
    private final boolean stopAtShutdown;
    private final Resource baseResource;
    private final String containerJarPattern;
    private final String webInfJarPattern;
    private final boolean dirAllowed;
    private final String tempDirectory;

    AbstractEmbeddedJettyConfiguration(AbstractEmbeddedJettyConfigurationBuilder<?, ?> builder) {
        super(builder.getClasspath(), builder.getPath(), builder.getWebapp(), builder.getPort(), builder.getEnvProperties(), builder.getHooks(), builder.getParentClassLoader(), builder.getOverrideDescriptor());
        this.stopTimeout = builder.getStopTimeout();
        this.stopAtShutdown = builder.isStopAtShutdown();
        this.baseResource = builder.getBaseResource();
        this.containerJarPattern = builder.getContainerJarPattern();
        this.webInfJarPattern = builder.getWebInfJarPattern();
        this.dirAllowed = builder.isDirAllowed();
        this.tempDirectory = builder.getTempDirectory();
    }

    public int getStopTimeout() {
        return this.stopTimeout;
    }

    public boolean isStopAtShutdown() {
        return this.stopAtShutdown;
    }

    public Resource getBaseResource() {
        return this.baseResource;
    }

    public String getContainerJarPattern() {
        return this.containerJarPattern;
    }

    public String getWebInfJarPattern() {
        return this.webInfJarPattern;
    }

    public boolean isDirAllowed() {
        return this.dirAllowed;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractEmbeddedJettyConfiguration) {
            AbstractEmbeddedJettyConfiguration c = (AbstractEmbeddedJettyConfiguration)o;
            return c.canEqual(this) && super.equals(c) && Objects.equals(this.stopTimeout, c.stopTimeout) && Objects.equals(this.stopAtShutdown, c.stopAtShutdown) && Objects.equals(this.baseResource, c.baseResource) && Objects.equals(this.containerJarPattern, c.containerJarPattern) && Objects.equals(this.webInfJarPattern, c.webInfJarPattern) && Objects.equals(this.dirAllowed, c.dirAllowed) && Objects.equals(this.tempDirectory, c.tempDirectory);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.stopTimeout, this.stopAtShutdown, this.baseResource, this.containerJarPattern, this.webInfJarPattern, this.dirAllowed, this.tempDirectory);
    }

    @Override
    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("port", this.getPort()).append("path", this.getPath()).append("webapp", this.getWebapp()).append("classpath", this.getClasspath()).append("overrideDescriptor", this.getOverrideDescriptor()).append("parentClassLoader", this.getParentClassLoader()).append("stopTimeout", this.stopTimeout).append("stopAtShutdown", this.stopAtShutdown).append("baseResource", this.baseResource).append("containerJarPattern", this.containerJarPattern).append("webInfJarPattern", this.webInfJarPattern).append("dirAllowed", this.dirAllowed).append("tempDirectory", this.tempDirectory).build();
    }
}

