/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jetty;

import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.jetty.AbstractEmbeddedJettyConfiguration;
import com.github.mjeanroy.junit.servers.servers.AbstractConfigurationBuilder;
import java.io.File;
import java.util.UUID;
import org.eclipse.jetty.util.resource.Resource;

abstract class AbstractEmbeddedJettyConfigurationBuilder<SELF extends AbstractEmbeddedJettyConfigurationBuilder<SELF, CONFIG>, CONFIG extends AbstractEmbeddedJettyConfiguration>
extends AbstractConfigurationBuilder<SELF, CONFIG> {
    private int stopTimeout = 30000;
    private boolean stopAtShutdown = true;
    private Resource baseResource;
    private String containerJarPattern;
    private String webInfJarPattern;
    private boolean dirAllowed = true;
    private String tempDirectory = new File("jsp").getAbsolutePath();

    protected AbstractEmbeddedJettyConfigurationBuilder() {
    }

    public int getStopTimeout() {
        return this.stopTimeout;
    }

    public boolean isStopAtShutdown() {
        return this.stopAtShutdown;
    }

    public Resource getBaseResource() {
        return this.baseResource;
    }

    public String getContainerJarPattern() {
        return this.containerJarPattern;
    }

    public String getWebInfJarPattern() {
        return this.webInfJarPattern;
    }

    public boolean isDirAllowed() {
        return this.dirAllowed;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public SELF withStopTimeout(int stopTimeout) {
        this.stopTimeout = Preconditions.positive(stopTimeout, "stopTimeout");
        return (SELF)((AbstractEmbeddedJettyConfigurationBuilder)this.self());
    }

    public SELF disableStopAtShutdown() {
        return this.toggleStopAtShutdown(false);
    }

    public SELF enableStopAtShutdown() {
        return this.toggleStopAtShutdown(true);
    }

    private SELF toggleStopAtShutdown(boolean stopAtShutdown) {
        this.stopAtShutdown = stopAtShutdown;
        return (SELF)((AbstractEmbeddedJettyConfigurationBuilder)this.self());
    }

    public SELF withBaseResource(Resource resource) {
        this.baseResource = resource;
        return (SELF)((AbstractEmbeddedJettyConfigurationBuilder)this.self());
    }

    public SELF withContainerJarPattern(String containerJarPattern) {
        this.containerJarPattern = containerJarPattern;
        return (SELF)((AbstractEmbeddedJettyConfigurationBuilder)this.self());
    }

    public SELF withWebInfJarPattern(String webInfJarPattern) {
        this.webInfJarPattern = webInfJarPattern;
        return (SELF)((AbstractEmbeddedJettyConfigurationBuilder)this.self());
    }

    public SELF withDirAllowed(boolean dirAllowed) {
        this.dirAllowed = dirAllowed;
        return (SELF)((AbstractEmbeddedJettyConfigurationBuilder)this.self());
    }

    public SELF withTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
        return (SELF)((AbstractEmbeddedJettyConfigurationBuilder)this.self());
    }

    public SELF withRandomTempDirectory() {
        this.tempDirectory = System.getProperty("java.io.tmpdir") + "/" + UUID.randomUUID();
        return (SELF)((AbstractEmbeddedJettyConfigurationBuilder)this.self());
    }
}

