/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jupiter;

import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.engine.EmbeddedServerRunner;
import com.github.mjeanroy.junit.servers.engine.Servers;
import com.github.mjeanroy.junit.servers.jupiter.ConfigurationResolverFunction;
import com.github.mjeanroy.junit.servers.jupiter.EmbeddedServerParameterResolverFunction;
import com.github.mjeanroy.junit.servers.jupiter.HttpClientParameterResolverFunction;
import com.github.mjeanroy.junit.servers.jupiter.JunitServerExtensionContext;
import com.github.mjeanroy.junit.servers.jupiter.JunitServerExtensionLifecycle;
import com.github.mjeanroy.junit.servers.jupiter.JunitServerTest;
import com.github.mjeanroy.junit.servers.jupiter.ParameterResolverFunction;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;

public class JunitServerExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final Logger log = LoggerFactory.getLogger(JunitServerExtension.class);
    private static final Map<Class<?>, ParameterResolverFunction> RESOLVERS = new HashMap();
    private final EmbeddedServer<?> server;
    private final AbstractConfiguration configuration;
    private final JunitServerExtensionLifecycle lifecycle;
    private final ExtensionContext.Namespace namespace;

    public JunitServerExtension() {
        this(null, null, null);
    }

    public JunitServerExtension(JunitServerExtensionLifecycle lifecycle) {
        this(Preconditions.notNull(lifecycle, "lifecycle"), null, null);
    }

    public JunitServerExtension(EmbeddedServer<?> server) {
        this(null, null, Preconditions.notNull(server, "server"));
    }

    public JunitServerExtension(JunitServerExtensionLifecycle lifecycle, EmbeddedServer<?> server) {
        this(Preconditions.notNull(lifecycle, "lifecycle"), null, Preconditions.notNull(server, "server"));
    }

    public JunitServerExtension(AbstractConfiguration configuration) {
        this(null, configuration, null);
    }

    public JunitServerExtension(JunitServerExtensionLifecycle lifecycle, AbstractConfiguration configuration) {
        this(Preconditions.notNull(lifecycle, "lifecycle"), configuration, null);
    }

    private JunitServerExtension(JunitServerExtensionLifecycle lifecycle, AbstractConfiguration configuration, EmbeddedServer<?> server) {
        this.lifecycle = lifecycle;
        this.configuration = configuration;
        this.server = server;
        this.namespace = ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass().getName()});
    }

    public void beforeAll(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        JunitServerExtensionLifecycle actualLifecycle = this.getLifecycle(testClass, JunitServerExtensionLifecycle.PER_CLASS);
        if (actualLifecycle == JunitServerExtensionLifecycle.PER_METHOD) {
            return;
        }
        JunitServerExtensionContext ctx = this.findContextInStore(context);
        if (ctx != null) {
            return;
        }
        this.start(actualLifecycle.getExtensionContext(context), testClass, actualLifecycle);
    }

    public void afterAll(ExtensionContext context) {
    }

    public void beforeEach(ExtensionContext context) {
        JunitServerExtensionContext ctx = this.findContextInStore(context);
        if (ctx == null) {
            Class testClass = context.getRequiredTestClass();
            JunitServerExtensionLifecycle actualLifecycle = this.getLifecycle(testClass, JunitServerExtensionLifecycle.PER_METHOD);
            ctx = this.start(actualLifecycle.getExtensionContext(context), testClass, actualLifecycle);
        }
        ctx.getAnnotationsHandler().beforeEach(context.getRequiredTestInstance());
    }

    public void afterEach(ExtensionContext context) {
        this.findContextInStore(context).getAnnotationsHandler().afterEach(context.getRequiredTestClass());
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ParameterResolverFunction resolver = JunitServerExtension.findResolver(parameterContext);
        return resolver != null;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ParameterResolverFunction resolver = JunitServerExtension.findResolver(parameterContext);
        if (resolver == null) {
            return null;
        }
        JunitServerExtensionContext ctx = this.findContextInStore(extensionContext);
        if (ctx == null) {
            return null;
        }
        return resolver.resolve(parameterContext, ctx.getRunner());
    }

    private static ParameterResolverFunction findResolver(ParameterContext parameterContext) {
        Parameter parameter = parameterContext.getParameter();
        Class<?> parameterClass = parameter.getType();
        if (RESOLVERS.containsKey(parameterClass)) {
            return RESOLVERS.get(parameterClass);
        }
        for (Class<?> klass : RESOLVERS.keySet()) {
            if (!klass.isAssignableFrom(parameterClass)) continue;
            return RESOLVERS.get(klass);
        }
        return null;
    }

    protected EmbeddedServer<?> instantiateServer(Class<?> testClass, AbstractConfiguration configuration) {
        log.debug("Instantiating embedded server for test class: {}", testClass);
        return Servers.instantiate(this.findConfiguration(testClass, configuration));
    }

    private AbstractConfiguration findConfiguration(Class<?> testClass, AbstractConfiguration configuration) {
        if (configuration != null) {
            return configuration;
        }
        return Servers.findConfiguration(testClass);
    }

    private JunitServerExtensionContext start(ExtensionContext context, Class<?> testClass, JunitServerExtensionLifecycle lifecycle) {
        log.debug("Register embedded server to junit extension context using lifecycle: {}", (Object)lifecycle);
        EmbeddedServer<?> server = this.server == null ? this.instantiateServer(testClass, this.configuration) : this.server;
        EmbeddedServerRunner runner = new EmbeddedServerRunner(server);
        JunitServerExtensionContext ctx = new JunitServerExtensionContext(runner);
        ctx.getRunner().beforeAll();
        this.putContextInStore(context, ctx);
        return ctx;
    }

    private JunitServerExtensionLifecycle getLifecycle(Class<?> testClass, JunitServerExtensionLifecycle defaults) {
        if (this.lifecycle != null) {
            return this.lifecycle;
        }
        return this.findLifecycle(testClass).orElse(defaults);
    }

    protected Optional<JunitServerExtensionLifecycle> findLifecycle(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, JunitServerTest.class).map(JunitServerTest::lifecycle);
    }

    private JunitServerExtensionContext findContextInStore(ExtensionContext context) {
        return (JunitServerExtensionContext)this.getExtensionStore(context).get((Object)JunitServerExtensionContext.class.getName(), JunitServerExtensionContext.class);
    }

    private void putContextInStore(ExtensionContext context, JunitServerExtensionContext ctx) {
        log.debug("Store context to junit extension context");
        this.getExtensionStore(context).put((Object)ctx.getClass().getName(), (Object)ctx);
    }

    private ExtensionContext.Store getExtensionStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(this.namespace);
    }

    static {
        RESOLVERS.put(EmbeddedServer.class, EmbeddedServerParameterResolverFunction.getInstance());
        RESOLVERS.put(AbstractConfiguration.class, ConfigurationResolverFunction.getInstance());
        RESOLVERS.put(HttpClient.class, HttpClientParameterResolverFunction.getInstance());
    }
}

