/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jetty9.jupiter;

import com.github.mjeanroy.junit.servers.jetty.EmbeddedJettyConfiguration;
import com.github.mjeanroy.junit.servers.jetty9.EmbeddedJetty;
import com.github.mjeanroy.junit.servers.jetty9.EmbeddedJettyFactory;
import com.github.mjeanroy.junit.servers.jetty9.jupiter.JettyTest;
import com.github.mjeanroy.junit.servers.jupiter.JunitServerExtension;
import com.github.mjeanroy.junit.servers.jupiter.JunitServerExtensionLifecycle;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.util.Optional;
import org.junit.platform.commons.support.AnnotationSupport;

public class JettyServerExtension
extends JunitServerExtension {
    private static final Logger log = LoggerFactory.getLogger(JettyServerExtension.class);

    public JettyServerExtension() {
    }

    public JettyServerExtension(JunitServerExtensionLifecycle lifecycle) {
        super(lifecycle);
    }

    public JettyServerExtension(EmbeddedJetty jetty) {
        super((EmbeddedServer)jetty);
    }

    public JettyServerExtension(JunitServerExtensionLifecycle lifecycle, EmbeddedJetty jetty) {
        super(lifecycle, (EmbeddedServer)jetty);
    }

    public JettyServerExtension(EmbeddedJettyConfiguration configuration) {
        super((AbstractConfiguration)configuration);
    }

    public JettyServerExtension(JunitServerExtensionLifecycle lifecycle, EmbeddedJettyConfiguration configuration) {
        super(lifecycle, (AbstractConfiguration)configuration);
    }

    protected EmbeddedServer<?> instantiateServer(Class<?> testClass, AbstractConfiguration configuration) {
        log.debug("Instantiating embedded jetty for test class: {}", testClass);
        return EmbeddedJettyFactory.createFrom(testClass, configuration);
    }

    protected Optional<JunitServerExtensionLifecycle> findLifecycle(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, JettyTest.class).map(JettyTest::lifecycle);
    }
}

