/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

public class WindowsGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsGlobalMemory.class);
    private long lastUpdate = 0L;
    private transient PerfDataUtil.PerfCounter pagesInputPerSecCounter = null;
    private transient PerfDataUtil.PerfCounter pagesOutputPerSecCounter = null;
    private transient WbemcliUtil.WmiQuery<PageSwapProperty> pageSwapsQuery = null;
    private transient PerfDataUtil.PerfCounter pagingPercentUsageCounter = null;
    private transient WbemcliUtil.WmiQuery<PagingPercentProperty> pagingPercentQuery = null;

    public WindowsGlobalMemory() {
        this.initPdhCounters();
    }

    private void initPdhCounters() {
        this.pagesInputPerSecCounter = PerfDataUtil.createCounter("Memory", null, "Pages Input/sec");
        this.pagesOutputPerSecCounter = PerfDataUtil.createCounter("Memory", null, "Pages Output/sec");
        if (!PerfDataUtil.addCounterToQuery(this.pagesInputPerSecCounter) || !PerfDataUtil.addCounterToQuery(this.pagesOutputPerSecCounter)) {
            this.initWmiSwapIoQuery();
        }
        this.pagingPercentUsageCounter = PerfDataUtil.createCounter("Paging File", "_Total", "% Usage");
        if (!PerfDataUtil.addCounterToQuery(this.pagingPercentUsageCounter)) {
            this.initWmiSwapUsageQuery();
        }
    }

    private void initWmiSwapIoQuery() {
        PerfDataUtil.removeCounterFromQuery(this.pagesInputPerSecCounter);
        this.pagesInputPerSecCounter = null;
        PerfDataUtil.removeCounterFromQuery(this.pagesOutputPerSecCounter);
        this.pagesOutputPerSecCounter = null;
        this.pageSwapsQuery = new WbemcliUtil.WmiQuery("Win32_PerfRawData_PerfOS_Memory", PageSwapProperty.class);
    }

    private void initWmiSwapUsageQuery() {
        PerfDataUtil.removeCounterFromQuery(this.pagingPercentUsageCounter);
        this.pagingPercentUsageCounter = null;
        this.pagingPercentQuery = new WbemcliUtil.WmiQuery("Win32_PerfRawData_PerfOS_PagingFile", PagingPercentProperty.class);
    }

    @Override
    protected void updateMeminfo() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate > 100L) {
            if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
                LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
                return;
            }
            this.pageSize = perfInfo.PageSize.longValue();
            this.memAvailable = this.pageSize * perfInfo.PhysicalAvailable.longValue();
            this.memTotal = this.pageSize * perfInfo.PhysicalTotal.longValue();
            this.swapTotal = this.pageSize * (perfInfo.CommitLimit.longValue() - perfInfo.PhysicalTotal.longValue());
            if (this.swapTotal > 0L) {
                this.updateSwapCounters();
            }
            this.lastUpdate = now;
        }
    }

    private void updateSwapCounters() {
        WbemcliUtil.WmiResult<PageSwapProperty> result;
        if (this.pageSwapsQuery == null) {
            long timeStamp = PerfDataUtil.updateQuery(this.pagesInputPerSecCounter);
            if (timeStamp > 0L) {
                this.swapPagesIn = PerfDataUtil.queryCounter(this.pagesInputPerSecCounter);
                this.swapPagesOut = PerfDataUtil.queryCounter(this.pagesOutputPerSecCounter);
            } else {
                this.initWmiSwapIoQuery();
            }
        }
        if (this.pageSwapsQuery != null && (result = WmiQueryHandler.getInstance().queryWMI(this.pageSwapsQuery)).getResultCount() > 0) {
            this.swapPagesIn = WmiUtil.getUint32(result, PageSwapProperty.PAGESINPUTPERSEC, 0);
            this.swapPagesOut = WmiUtil.getUint32(result, PageSwapProperty.PAGESOUTPUTPERSEC, 0);
        }
    }

    @Override
    protected void updateSwap() {
        this.updateMeminfo();
        if (this.swapTotal > 0L) {
            WbemcliUtil.WmiResult<PagingPercentProperty> result;
            if (this.pagingPercentQuery == null) {
                long timeStamp = PerfDataUtil.updateQuery(this.pagingPercentUsageCounter);
                if (timeStamp > 0L) {
                    this.swapUsed = PerfDataUtil.queryCounter(this.pagingPercentUsageCounter) * this.pageSize;
                } else {
                    this.initWmiSwapUsageQuery();
                }
            }
            if (this.pagingPercentQuery != null && (result = WmiQueryHandler.getInstance().queryWMI(this.pagingPercentQuery)).getResultCount() > 0) {
                this.swapUsed = (long)WmiUtil.getUint32(result, PagingPercentProperty.PERCENTUSAGE, 0) * this.pageSize;
            }
        }
    }

    static enum PagingPercentProperty {
        PERCENTUSAGE;

    }

    static enum PageSwapProperty {
        PAGESINPUTPERSEC,
        PAGESOUTPUTPERSEC;

    }
}

