/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.freebsd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.ExecutingCommand;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;

public class FreeBsdFileSystem
implements FileSystem {
    private static final long serialVersionUID = 1L;
    private final List<String> pseudofs = Arrays.asList("procfs", "devfs", "ctfs", "fdescfs", "objfs", "mntfs", "sharefs", "lofs", "autofs");
    private final List<String> tmpfsPaths = Arrays.asList("/system", "/tmp", "/dev/fd");

    private boolean listElementStartsWith(List<String> aList, String charSeq) {
        for (String match : aList) {
            if (!charSeq.equals(match) && !charSeq.startsWith(match + "/")) continue;
            return true;
        }
        return false;
    }

    @Override
    public OSFileStore[] getFileStores() {
        String[] split;
        HashMap<String, String> uuidMap = new HashMap<String, String>();
        String device = "";
        for (String line : ExecutingCommand.runNative("geom part list")) {
            if (line.contains("Name: ")) {
                device = line.substring(line.lastIndexOf(32) + 1);
            }
            if (device.isEmpty() || !(line = line.trim()).startsWith("rawuuid:")) continue;
            uuidMap.put(device, line.substring(line.lastIndexOf(32) + 1));
            device = "";
        }
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        HashMap<String, Long> inodeFreeMap = new HashMap<String, Long>();
        HashMap<String, Long> inodeTotalMap = new HashMap<String, Long>();
        for (String line : ExecutingCommand.runNative("df -i")) {
            if (!line.startsWith("/") || (split = ParseUtil.whitespaces.split(line)).length <= 7) continue;
            inodeFreeMap.put(split[0], ParseUtil.parseLongOrDefault(split[6], 0L));
            inodeTotalMap.put(split[0], (Long)inodeFreeMap.get(split[0]) + ParseUtil.parseLongOrDefault(split[5], 0L));
        }
        for (String fs : ExecutingCommand.runNative("mount -p")) {
            split = ParseUtil.whitespaces.split(fs);
            if (split.length < 5) continue;
            String volume = split[0];
            String path = split[1];
            String type = split[2];
            if (this.pseudofs.contains(type) || path.equals("/dev") || this.listElementStartsWith(this.tmpfsPaths, path) || volume.startsWith("rpool") && !path.equals("/")) continue;
            String name = path.substring(path.lastIndexOf(47) + 1);
            if (name.isEmpty()) {
                name = volume.substring(volume.lastIndexOf(47) + 1);
            }
            long totalSpace = new File(path).getTotalSpace();
            long usableSpace = new File(path).getUsableSpace();
            String description = volume.startsWith("/dev") || path.equals("/") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (type.startsWith("nfs") || type.equals("cifs") ? "Network Disk" : "Mount Point"));
            String uuid = MapUtil.getOrDefault(uuidMap, name, "");
            OSFileStore osStore = new OSFileStore();
            osStore.setName(name);
            osStore.setVolume(volume);
            osStore.setMount(path);
            osStore.setDescription(description);
            osStore.setType(type);
            osStore.setUUID(uuid);
            osStore.setUsableSpace(usableSpace);
            osStore.setTotalSpace(totalSpace);
            osStore.setFreeInodes(inodeFreeMap.containsKey(path) ? (Long)inodeFreeMap.get(path) : 0L);
            osStore.setTotalInodes(inodeTotalMap.containsKey(path) ? (Long)inodeTotalMap.get(path) : 0L);
            fsList.add(osStore);
        }
        return fsList.toArray(new OSFileStore[fsList.size()]);
    }

    @Override
    public long getOpenFileDescriptors() {
        return BsdSysctlUtil.sysctl("kern.openfiles", 0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return BsdSysctlUtil.sysctl("kern.maxfiles", 0);
    }
}

