/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux;

import com.sun.jna.Native;
import com.sun.jna.platform.linux.LibC;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.common.AbstractFileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.linux.LinuxOSFileStore;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;

@ThreadSafe
public class LinuxFileSystem
extends AbstractFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxFileSystem.class);
    private static final String UNICODE_SPACE = "\\\\040";
    private static final List<String> TMP_FS_PATHS = Arrays.asList("/run", "/sys", "/proc", ProcPath.PROC);

    @Override
    public List<OSFileStore> getFileStores(boolean localOnly) {
        HashMap<String, String> uuidMap = new HashMap<String, String>();
        File uuidDir = new File("/dev/disk/by-uuid");
        if (uuidDir.listFiles() != null) {
            for (File uuid : uuidDir.listFiles()) {
                try {
                    uuidMap.put(uuid.getCanonicalPath(), uuid.getName().toLowerCase());
                }
                catch (IOException e) {
                    LOG.error("Couldn't get canonical path for {}. {}", (Object)uuid.getName(), (Object)e.getMessage());
                }
            }
        }
        return LinuxFileSystem.getFileStoreMatching(null, uuidMap, localOnly);
    }

    static List<OSFileStore> getFileStoreMatching(String nameToMatch, Map<String, String> uuidMap) {
        return LinuxFileSystem.getFileStoreMatching(nameToMatch, uuidMap, false);
    }

    private static List<OSFileStore> getFileStoreMatching(String nameToMatch, Map<String, String> uuidMap, boolean localOnly) {
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        List<String> mounts = FileUtil.readFile(ProcPath.MOUNTS);
        for (String mount : mounts) {
            String uuid;
            String[] split = mount.split(" ");
            if (split.length < 6) continue;
            String path = split[1].replaceAll(UNICODE_SPACE, " ");
            String type = split[2];
            if (localOnly && NETWORK_FS_TYPES.contains(type) || PSEUDO_FS_TYPES.contains(type) || path.equals("/dev") || ParseUtil.filePathStartsWith(TMP_FS_PATHS, path) || path.endsWith("/shm")) continue;
            String options = split[3];
            String name = split[0].replaceAll(UNICODE_SPACE, " ");
            if (path.equals("/")) {
                name = "/";
            }
            if (nameToMatch != null && !nameToMatch.equals(name)) continue;
            String volume = split[0].replaceAll(UNICODE_SPACE, " ");
            String string = uuid = uuidMap != null ? uuidMap.getOrDefault(split[0], "") : "";
            String description = volume.startsWith("/dev") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (NETWORK_FS_TYPES.contains(type) ? "Network Disk" : "Mount Point"));
            String logicalVolume = "";
            String volumeMapperDirectory = "/dev/mapper/";
            Path link = Paths.get(volume, new String[0]);
            if (link.toFile().exists() && Files.isSymbolicLink(link)) {
                try {
                    Path slink = Files.readSymbolicLink(link);
                    Path full = Paths.get(volumeMapperDirectory + slink.toString(), new String[0]);
                    if (full.toFile().exists()) {
                        logicalVolume = full.normalize().toString();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Couldn't access symbolic path  {}. {}", (Object)link, (Object)e.getMessage());
                }
            }
            long totalInodes = 0L;
            long freeInodes = 0L;
            long totalSpace = 0L;
            long usableSpace = 0L;
            long freeSpace = 0L;
            try {
                LibC.Statvfs vfsStat = new LibC.Statvfs();
                if (0 == LibC.INSTANCE.statvfs(path, vfsStat)) {
                    totalInodes = vfsStat.f_files.longValue();
                    freeInodes = vfsStat.f_ffree.longValue();
                    totalSpace = vfsStat.f_blocks.longValue() * vfsStat.f_bsize.longValue();
                    usableSpace = vfsStat.f_bavail.longValue() * vfsStat.f_bsize.longValue();
                    freeSpace = vfsStat.f_bfree.longValue() * vfsStat.f_bsize.longValue();
                } else {
                    File tmpFile = new File(path);
                    totalSpace = tmpFile.getTotalSpace();
                    usableSpace = tmpFile.getUsableSpace();
                    freeSpace = tmpFile.getFreeSpace();
                    LOG.warn("Failed to get information to use statvfs. path: {}, Error code: {}", (Object)path, (Object)Native.getLastError());
                }
            }
            catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
                LOG.error("Failed to get file counts from statvfs. {}", (Object)e.getMessage());
            }
            fsList.add(new LinuxOSFileStore(name, volume, name, path, options, uuid, logicalVolume, description, type, freeSpace, usableSpace, totalSpace, freeInodes, totalInodes));
        }
        return fsList;
    }

    @Override
    public long getOpenFileDescriptors() {
        return LinuxFileSystem.getFileDescriptors(0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return LinuxFileSystem.getFileDescriptors(2);
    }

    private static long getFileDescriptors(int index) {
        String filename = ProcPath.SYS_FS_FILE_NR;
        if (index < 0 || index > 2) {
            throw new IllegalArgumentException("Index must be between 0 and 2.");
        }
        List<String> osDescriptors = FileUtil.readFile(filename);
        if (!osDescriptors.isEmpty()) {
            String[] splittedLine = osDescriptors.get(0).split("\\D+");
            return ParseUtil.parseLongOrDefault(splittedLine[index], 0L);
        }
        return 0L;
    }
}

