/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.PdhUtil;
import com.sun.jna.platform.win32.Win32Exception;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.NotThreadSafe;
import oshi.util.Util;
import oshi.util.platform.windows.PerfCounterQuery;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

@NotThreadSafe
public class PerfCounterWildcardQuery<T extends Enum<T>>
extends PerfCounterQuery<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PerfCounterWildcardQuery.class);
    private EnumMap<T, List<PerfDataUtil.PerfCounter>> counterListMap = null;
    private List<String> instancesFromLastQuery = new ArrayList<String>();
    private final String perfObjectLocalized;
    private final String instanceFilter;

    public PerfCounterWildcardQuery(Class<T> propertyEnum, String perfObject, String perfWmiClass) {
        this(propertyEnum, perfObject, perfWmiClass, perfObject);
    }

    public PerfCounterWildcardQuery(Class<T> propertyEnum, String perfObject, String perfWmiClass, String queryKey) {
        super(propertyEnum, perfObject, perfWmiClass, queryKey);
        if (((Enum[])propertyEnum.getEnumConstants()).length < 2) {
            throw new IllegalArgumentException("Enum " + propertyEnum.getName() + " must have at least two elements, an instance filter and a counter.");
        }
        this.instanceFilter = ((PdhCounterWildcardProperty)((Object)((Enum[])propertyEnum.getEnumConstants())[0])).getCounter().toLowerCase();
        this.perfObjectLocalized = PerfCounterWildcardQuery.localize(this.perfObject);
    }

    private static String localize(String perfObject) {
        String localized = null;
        try {
            localized = PdhUtil.PdhLookupPerfNameByIndex(null, (int)PdhUtil.PdhLookupPerfIndexByEnglishName((String)perfObject));
        }
        catch (Win32Exception e) {
            LOG.error("Unable to locate English counter names in registry Perflib 009. Assuming English counters. Error {}. {}", (Object)String.format("0x%x", e.getHR().intValue()), (Object)"See https://support.microsoft.com/en-us/help/300956/how-to-manually-rebuild-performance-counter-library-values");
        }
        catch (PdhUtil.PdhException e) {
            LOG.error("Unable to localize {} performance counter.  Error {}.", (Object)perfObject, (Object)String.format("0x%x", e.getErrorCode()));
        }
        if (localized == null || localized.length() == 0) {
            return perfObject;
        }
        LOG.debug("Localized {} to {}", (Object)perfObject, (Object)localized);
        return localized;
    }

    @Override
    protected boolean initPdhCounters() {
        return this.fillCounterListMap();
    }

    @Override
    protected void unInitPdhCounters() {
        this.pdhQueryHandler.removeAllCountersFromQuery(this.queryKey);
        this.counterListMap = null;
    }

    @Override
    public Map<T, Long> queryValues() {
        throw new UnsupportedOperationException("Use queryValuesWildcard() on this class.");
    }

    public Map<T, List<Long>> queryValuesWildcard() {
        EnumMap valueMap = new EnumMap(this.propertyEnum);
        this.instancesFromLastQuery.clear();
        Enum[] props = (Enum[])this.propertyEnum.getEnumConstants();
        if (this.source.equals((Object)PerfCounterQuery.CounterDataSource.PDH)) {
            if (this.initPdhCounters() && this.queryPdhWildcard(valueMap, props)) {
                this.unInitPdhCounters();
            } else {
                this.setDataSource(PerfCounterQuery.CounterDataSource.WMI);
            }
        }
        if (this.source.equals((Object)PerfCounterQuery.CounterDataSource.WMI)) {
            this.queryWmiWildcard(valueMap, props);
        }
        return valueMap;
    }

    private boolean queryPdhWildcard(Map<T, List<Long>> valueMap, T[] props) {
        if (this.counterListMap != null && 0L < this.pdhQueryHandler.updateQuery(this.queryKey)) {
            for (int i = 1; i < props.length; ++i) {
                T prop = props[i];
                ArrayList<Long> values = new ArrayList<Long>();
                for (PerfDataUtil.PerfCounter counter : this.counterListMap.get(prop)) {
                    values.add(this.pdhQueryHandler.queryCounter(counter));
                    if (i != 1) continue;
                    this.instancesFromLastQuery.add(counter.getInstance());
                }
                valueMap.put(prop, values);
            }
            return true;
        }
        return false;
    }

    private void queryWmiWildcard(Map<T, List<Long>> valueMap, T[] props) {
        WbemcliUtil.WmiResult result = WmiQueryHandler.createInstance().queryWMI(this.counterQuery);
        if (result.getResultCount() > 0) {
            for (int i = 0; i < result.getResultCount(); ++i) {
                this.instancesFromLastQuery.add(WmiUtil.getString(result, props[0], i));
            }
            for (int p = 1; p < props.length; ++p) {
                T prop = props[p];
                ArrayList<Long> values = new ArrayList<Long>();
                block8: for (int i = 0; i < result.getResultCount(); ++i) {
                    switch (result.getCIMType(prop)) {
                        case 18: {
                            values.add(Long.valueOf(WmiUtil.getUint16(result, prop, i)));
                            continue block8;
                        }
                        case 19: {
                            values.add(WmiUtil.getUint32asLong(result, prop, i));
                            continue block8;
                        }
                        case 21: {
                            values.add(WmiUtil.getUint64(result, prop, i));
                            continue block8;
                        }
                        case 101: {
                            values.add(WmiUtil.getDateTime(result, prop, i).toInstant().toEpochMilli());
                            continue block8;
                        }
                        default: {
                            throw new ClassCastException("Unimplemented CIM Type Mapping.");
                        }
                    }
                }
                valueMap.put(prop, values);
            }
        }
    }

    public List<String> getInstancesFromLastQuery() {
        return this.instancesFromLastQuery;
    }

    private boolean fillCounterListMap() {
        PdhUtil.PdhEnumObjectItems objectItems;
        try {
            objectItems = PdhUtil.PdhEnumObjectItems(null, null, (String)this.perfObjectLocalized, (int)100);
        }
        catch (PdhUtil.PdhException e) {
            return false;
        }
        List instances = objectItems.getInstances();
        instances.removeIf(i -> !Util.wildcardMatch(i.toLowerCase(), this.instanceFilter));
        HashSet instancesToAdd = new HashSet(instances);
        this.counterListMap = new EnumMap(this.propertyEnum);
        for (int i2 = 1; i2 < ((Enum[])this.propertyEnum.getEnumConstants()).length; ++i2) {
            Enum prop = ((Enum[])this.propertyEnum.getEnumConstants())[i2];
            ArrayList<PerfDataUtil.PerfCounter> counterList = new ArrayList<PerfDataUtil.PerfCounter>(instances.size());
            for (String instance : instancesToAdd) {
                PerfDataUtil.PerfCounter counter = PerfDataUtil.createCounter(this.perfObject, instance, ((PdhCounterWildcardProperty)((Object)prop)).getCounter());
                if (!this.pdhQueryHandler.addCounterToQuery(counter, this.queryKey)) {
                    this.unInitPdhCounters();
                    return false;
                }
                counterList.add(counter);
            }
            this.counterListMap.put(prop, counterList);
        }
        return this.counterListMap.size() > 0;
    }

    public static interface PdhCounterWildcardProperty {
        public String getCounter();
    }
}

