/*
 * Decompiled with CFR 0.152.
 */
package oshi.jna.platform.windows;

import com.sun.jna.IntegerType;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;

public interface WinNT
extends com.sun.jna.platform.win32.WinNT {

    @Structure.FieldOrder(value={"u"})
    public static class LARGE_INTEGER
    extends Structure
    implements Comparable<LARGE_INTEGER> {
        public UNION u;

        public LARGE_INTEGER() {
        }

        public LARGE_INTEGER(long value) {
            this.u = new UNION(value);
        }

        public WinDef.DWORD getLow() {
            return this.u.lh.LowPart;
        }

        public WinDef.DWORD getHigh() {
            return this.u.lh.HighPart;
        }

        public long getValue() {
            return this.u.value;
        }

        @Override
        public int compareTo(LARGE_INTEGER other) {
            return LARGE_INTEGER.compare(this, other);
        }

        public String toString() {
            return this.u == null ? "null" : Long.toString(this.getValue());
        }

        public static int compare(LARGE_INTEGER v1, LARGE_INTEGER v2) {
            if (v1 == v2) {
                return 0;
            }
            if (v1 == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            return IntegerType.compare((long)v1.getValue(), (long)v2.getValue());
        }

        public static int compare(LARGE_INTEGER v1, long v2) {
            if (v1 == null) {
                return 1;
            }
            return IntegerType.compare((long)v1.getValue(), (long)v2);
        }

        public static class UNION
        extends Union {
            public LowHigh lh;
            public long value;

            public UNION() {
            }

            public UNION(long value) {
                this.value = value;
                this.lh = new LowHigh(value);
            }

            public long longValue() {
                return this.value;
            }

            public void read() {
                this.readField("lh");
                this.readField("value");
            }

            public String toString() {
                return Long.toString(this.longValue());
            }
        }

        @Structure.FieldOrder(value={"LowPart", "HighPart"})
        public static class LowHigh
        extends Structure {
            public WinDef.DWORD LowPart;
            public WinDef.DWORD HighPart;

            public LowHigh() {
            }

            public LowHigh(long value) {
                this(new WinDef.DWORD(value & 0xFFFFFFFFL), new WinDef.DWORD(value >> 32 & 0xFFFFFFFFL));
            }

            public LowHigh(WinDef.DWORD low, WinDef.DWORD high) {
                this.LowPart = low;
                this.HighPart = high;
            }

            public long longValue() {
                long loValue = this.LowPart.longValue();
                long hiValue = this.HighPart.longValue();
                return hiValue << 32 & 0xFFFFFFFF00000000L | loValue & 0xFFFFFFFFL;
            }

            public String toString() {
                if (this.LowPart == null || this.HighPart == null) {
                    return "null";
                }
                return Long.toString(this.longValue());
            }
        }

        public static class ByReference
        extends LARGE_INTEGER
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"PrimaryGroup"})
    public static class TOKEN_PRIMARY_GROUP
    extends Structure {
        public WinNT.PSID.ByReference PrimaryGroup;

        public TOKEN_PRIMARY_GROUP() {
        }

        public TOKEN_PRIMARY_GROUP(Pointer memory) {
            super(memory);
            this.read();
        }

        public TOKEN_PRIMARY_GROUP(int size) {
            super((Pointer)new Memory((long)size));
        }
    }
}

