/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.common;

import com.sun.jna.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import oshi.driver.unix.Who;
import oshi.driver.unix.Xwininfo;
import oshi.software.os.OSDesktopWindow;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OSSession;
import oshi.software.os.OperatingSystem;
import oshi.util.ExecutingCommand;
import oshi.util.GlobalConfig;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;

public abstract class AbstractOperatingSystem
implements OperatingSystem {
    public static final String OSHI_OS_UNIX_WHOCOMMAND = "oshi.os.unix.whoCommand";
    protected static final boolean USE_WHO_COMMAND = GlobalConfig.get("oshi.os.unix.whoCommand", false);
    private final Supplier<String> manufacturer = Memoizer.memoize(this::queryManufacturer);
    private final Supplier<FamilyVersionInfo> familyVersionInfo = Memoizer.memoize(this::queryFamilyVersionInfo);
    private final Supplier<Integer> bitness = Memoizer.memoize(this::queryPlatformBitness);
    private static final Comparator<OSProcess> CPU_DESC_SORT = Comparator.comparingDouble(OSProcess::getProcessCpuLoadCumulative).reversed();
    private static final Comparator<OSProcess> RSS_DESC_SORT = Comparator.comparingLong(OSProcess::getResidentSetSize).reversed();
    private static final Comparator<OSProcess> UPTIME_ASC_SORT = Comparator.comparingLong(OSProcess::getUpTime);
    private static final Comparator<OSProcess> UPTIME_DESC_SORT = UPTIME_ASC_SORT.reversed();
    private static final Comparator<OSProcess> PID_ASC_SORT = Comparator.comparingInt(OSProcess::getProcessID);
    private static final Comparator<OSProcess> PARENTPID_ASC_SORT = Comparator.comparingInt(OSProcess::getParentProcessID);
    private static final Comparator<OSProcess> NAME_ASC_SORT = Comparator.comparing(OSProcess::getName, String.CASE_INSENSITIVE_ORDER);

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    protected abstract String queryManufacturer();

    @Override
    public String getFamily() {
        return this.familyVersionInfo.get().family;
    }

    @Override
    public OperatingSystem.OSVersionInfo getVersionInfo() {
        return this.familyVersionInfo.get().versionInfo;
    }

    protected abstract FamilyVersionInfo queryFamilyVersionInfo();

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    private int queryPlatformBitness() {
        if (Platform.is64Bit()) {
            return 64;
        }
        int jvmBitness = System.getProperty("os.arch").indexOf("64") != -1 ? 64 : 32;
        return this.queryBitness(jvmBitness);
    }

    protected abstract int queryBitness(int var1);

    @Override
    public boolean isElevated() {
        return 0 == ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("id -u"), -1);
    }

    @Override
    public OSService[] getServices() {
        return new OSService[0];
    }

    protected List<OSProcess> processSort(List<OSProcess> processes, int limit, OperatingSystem.ProcessSort sort) {
        if (sort != null) {
            switch (sort) {
                case CPU: {
                    processes.sort(CPU_DESC_SORT);
                    break;
                }
                case MEMORY: {
                    processes.sort(RSS_DESC_SORT);
                    break;
                }
                case OLDEST: {
                    processes.sort(UPTIME_DESC_SORT);
                    break;
                }
                case NEWEST: {
                    processes.sort(UPTIME_ASC_SORT);
                    break;
                }
                case PID: {
                    processes.sort(PID_ASC_SORT);
                    break;
                }
                case PARENTPID: {
                    processes.sort(PARENTPID_ASC_SORT);
                    break;
                }
                case NAME: {
                    processes.sort(NAME_ASC_SORT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unimplemented enum type: " + sort.toString());
                }
            }
        }
        int maxProcs = processes.size();
        if (limit <= 0 || maxProcs <= limit) {
            return processes;
        }
        maxProcs = limit;
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        for (int i = 0; i < maxProcs; ++i) {
            procs.add(processes.get(i));
        }
        return procs;
    }

    @Override
    public List<OSSession> getSessions() {
        return Who.queryWho();
    }

    @Override
    public List<OSProcess> getProcesses() {
        return this.getProcesses(0, null);
    }

    @Override
    public List<OSProcess> getProcesses(Collection<Integer> pids) {
        return pids.stream().map(this::getProcess).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<OSProcess> getChildProcesses(int parentPid, int limit, OperatingSystem.ProcessSort sort) {
        List<OSProcess> procList = this.getProcesses(0, null).stream().filter(proc -> parentPid == proc.getParentProcessID()).collect(Collectors.toList());
        return this.processSort(procList, limit, sort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getManufacturer()).append(' ').append(this.getFamily()).append(' ').append(this.getVersionInfo());
        return sb.toString();
    }

    @Override
    public List<OSDesktopWindow> getDesktopWindows(boolean visibleOnly) {
        return Xwininfo.queryXWindows(visibleOnly);
    }

    protected static final class FamilyVersionInfo {
        private final String family;
        private final OperatingSystem.OSVersionInfo versionInfo;

        public FamilyVersionInfo(String family, OperatingSystem.OSVersionInfo versionInfo) {
            this.family = family;
            this.versionInfo = versionInfo;
        }
    }
}

