/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.safetensors.prompt;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.objects.collections.PyMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonPropertyOrder(value={"type", "properties", "required"})
public class Parameters
extends PyMap {
    public static final String JSON_PROPERTY_TYPE = "type";
    private final String type = "object";
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    public static final String JSON_PROPERTY_REQUIRED = "required";
    private List<String> required;

    public Parameters(Map<String, Map<String, Object>> properties, List<String> required) {
        super((Map)ImmutableMap.builder().put((Object)JSON_PROPERTY_TYPE, (Object)"object").put((Object)JSON_PROPERTY_PROPERTIES, properties).put((Object)JSON_PROPERTY_REQUIRED, required).build());
        this.required = required;
    }

    public Parameters(Map<String, Map<String, Object>> properties) {
        super((Map)ImmutableMap.builder().put((Object)JSON_PROPERTY_TYPE, (Object)"object").put((Object)JSON_PROPERTY_PROPERTIES, properties).build());
        this.required = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getProperties() {
        return this;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public static class Builder {
        private Map<String, Map<String, Object>> properties = new LinkedHashMap<String, Map<String, Object>>();
        private Set<String> required = new LinkedHashSet<String>();

        public Builder addProperty(String name, String type, String description, boolean required) {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put(Parameters.JSON_PROPERTY_TYPE, type);
            properties.put("description", description);
            return this.addProperty(name, properties, required);
        }

        public Builder addProperty(String name, Map<String, Object> properties, boolean required) {
            this.properties.put(name, properties);
            if (required) {
                this.required.add(name);
            }
            return this;
        }

        public Parameters build() {
            return new Parameters(this.properties, new ArrayList<String>(this.required));
        }
    }
}

