/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.safetensors.prompt;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.github.tjake.jlama.util.JsonSupport;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "tool_call_id"})
public class ToolCall {
    public static final ArrayType toolCallListTypeReference = JsonSupport.om.getTypeFactory().constructArrayType(ToolCall.class);
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String id;
    @JsonProperty(value="parameters")
    private final Map<String, Object> parameters;

    @JsonCreator
    public ToolCall(@JsonProperty(value="name") String name, @JsonAlias(value={"arguments"}) @JsonProperty(value="parameters") Map<String, Object> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    public ToolCall(String name, String id, Map<String, Object> parameters) {
        this.name = name;
        this.id = id;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolCall toolCall = (ToolCall)o;
        return Objects.equals(this.name, toolCall.name) && Objects.equals(this.parameters, toolCall.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parameters);
    }
}

