/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.tensor.operations;

import com.github.tjake.jlama.tensor.operations.NaiveTensorOperations;
import com.github.tjake.jlama.tensor.operations.PanamaTensorOperations;
import com.github.tjake.jlama.tensor.operations.TensorOperations;
import com.github.tjake.jlama.util.MachineSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TensorOperationsProvider {
    private static final Logger logger;
    private static final boolean forcePanama;
    private static final String lock = "lock";
    private static TensorOperationsProvider instance;
    private final TensorOperations provider = this.pickFastestImplementation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TensorOperations get() {
        if (instance != null) return TensorOperationsProvider.instance.provider;
        String string = lock;
        synchronized (lock) {
            if (instance != null) return TensorOperationsProvider.instance.provider;
            instance = new TensorOperationsProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return TensorOperationsProvider.instance.provider;
        }
    }

    private TensorOperationsProvider() {
    }

    private TensorOperations pickFastestImplementation() {
        TensorOperations pick = null;
        if (!forcePanama) {
            try {
                Class<?> nativeClazz = Class.forName("com.github.tjake.jlama.tensor.operations.NativeTensorOperations");
                pick = (TensorOperations)nativeClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                logger.warn("Native operations not available. Consider adding 'com.github.tjake:jlama-native' to the classpath");
            }
        }
        if (pick == null) {
            pick = MachineSpec.VECTOR_TYPE == MachineSpec.Type.NONE ? new NaiveTensorOperations() : new PanamaTensorOperations(MachineSpec.VECTOR_TYPE);
        }
        logger.info("Using {} ({})", (Object)pick.name(), (Object)"OffHeap");
        return pick;
    }

    static {
        System.setProperty("jdk.incubator.vector.VECTOR_ACCESS_OOB_CHECK", "0");
        logger = LoggerFactory.getLogger(TensorOperationsProvider.class);
        forcePanama = Boolean.getBoolean("jlama.force_panama_tensor_operations");
    }
}

