/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.util;

import com.github.tjake.jlama.util.Pair;
import com.github.tjake.jlama.util.TriConsumer;
import com.google.common.io.CountingInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSupport {
    public static final Logger logger = LoggerFactory.getLogger(HttpSupport.class);

    public static Pair<InputStream, Long> getResponse(String urlString, Optional<String> optionalAuthHeader, Optional<Pair<Long, Long>> optionalByteRange) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept-Encoding", "gzip");
        optionalAuthHeader.ifPresent(authHeader -> connection.setRequestProperty("Authorization", "Bearer " + authHeader));
        optionalByteRange.ifPresent(byteRange -> connection.setRequestProperty("Range", "bytes=" + String.valueOf(byteRange.left) + "-" + String.valueOf(byteRange.right)));
        int responseCode = connection.getResponseCode();
        if (responseCode == 200 || responseCode == 206) {
            String encoding = connection.getContentEncoding();
            InputStream inputStream = encoding != null && encoding.equals("gzip") ? new GZIPInputStream(connection.getInputStream()) : connection.getInputStream();
            return Pair.of(inputStream, connection.getContentLengthLong());
        }
        throw new IOException("HTTP response code: " + responseCode + " for URL: " + urlString);
    }

    public static String readInputStream(InputStream inStream) throws IOException {
        String currLine;
        if (inStream == null) {
            return null;
        }
        BufferedReader inReader = new BufferedReader(new InputStreamReader(inStream));
        StringBuilder stringBuilder = new StringBuilder();
        while ((currLine = inReader.readLine()) != null) {
            stringBuilder.append(currLine);
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    public static void downloadFile(String hfModel, String currFile, Optional<String> optionalBranch, Optional<String> optionalAuthHeader, Optional<Pair<Long, Long>> optionalByteRange, Path outputPath, Optional<TriConsumer<String, Long, Long>> optionalProgressConsumer) throws IOException {
        Pair<InputStream, Long> stream = HttpSupport.getResponse("https://huggingface.co/" + hfModel + "/resolve/" + optionalBranch.orElse("main") + "/" + currFile, optionalAuthHeader, optionalByteRange);
        CountingInputStream inStream = new CountingInputStream((InputStream)stream.left);
        long totalBytes = (Long)stream.right;
        if (outputPath.toFile().exists() && outputPath.toFile().length() == totalBytes) {
            logger.debug("File already exists: {}", (Object)outputPath);
            return;
        }
        if (optionalProgressConsumer.isEmpty()) {
            logger.info("Downloading file: {}", (Object)outputPath);
        }
        optionalProgressConsumer.ifPresent(p -> p.accept(currFile, 0L, totalBytes));
        CompletableFuture<Long> result = CompletableFuture.supplyAsync(() -> {
            try {
                return Files.copy((InputStream)inStream, outputPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        optionalProgressConsumer.ifPresent(p -> {
            while (!result.isDone()) {
                p.accept(currFile, inStream.getCount(), totalBytes);
            }
            if (result.isCompletedExceptionally()) {
                p.accept(currFile, inStream.getCount(), totalBytes);
            } else {
                p.accept(currFile, totalBytes, totalBytes);
            }
        });
        try {
            result.get();
        }
        catch (Throwable e) {
            throw new IOException("Failed to download file: " + currFile, e);
        }
        if (optionalProgressConsumer.isEmpty() && !result.isCompletedExceptionally()) {
            logger.info("Downloaded file: {}", (Object)outputPath);
        }
    }
}

