/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonSupport {
    private static final String JSON_REGEX = "\\{\\s*\"name\"\\s*:\\s*\"[^\"]+\"\\s*(,\\s*\"[^\"]+\"\\s*:\\s*(\"[^\"]*\"|\\d+|true|false|null|\\{[^{}]*\\}|\\[[^\\[\\]]*\\]))*\\s*\\}";
    private static final Pattern JSON_PATTERN = Pattern.compile("\\{\\s*\"name\"\\s*:\\s*\"[^\"]+\"\\s*(,\\s*\"[^\"]+\"\\s*:\\s*(\"[^\"]*\"|\\d+|true|false|null|\\{[^{}]*\\}|\\[[^\\[\\]]*\\]))*\\s*\\}");
    public static final ObjectMapper om = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, false).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});

    public static String toJson(Object o) {
        try {
            return om.writer((PrettyPrinter)JlamaPrettyPrinter.INSTANCE).writeValueAsString(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> extractJsonFromString(String s) {
        Matcher matcher = JSON_PATTERN.matcher(s);
        ArrayList<String> extractedJson = new ArrayList<String>();
        while (matcher.find()) {
            String json = matcher.group();
            extractedJson.add(json);
        }
        return extractedJson;
    }

    public static class JlamaPrettyPrinter
    extends DefaultPrettyPrinter {
        public static final JlamaPrettyPrinter INSTANCE = new JlamaPrettyPrinter();

        public DefaultPrettyPrinter createInstance() {
            return INSTANCE;
        }

        private JlamaPrettyPrinter() {
            this._objectIndenter = DefaultPrettyPrinter.FixedSpaceIndenter.instance;
            this._spacesInObjectEntries = false;
        }

        public void beforeArrayValues(JsonGenerator jg) {
        }

        public void writeEndArray(JsonGenerator jg, int nrOfValues) throws IOException {
            if (!this._arrayIndenter.isInline()) {
                --this._nesting;
            }
            jg.writeRaw(']');
        }

        public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(": ");
        }

        public void beforeObjectEntries(JsonGenerator jg) {
        }

        public void writeEndObject(JsonGenerator jg, int nrOfEntries) throws IOException {
            if (!this._objectIndenter.isInline()) {
                --this._nesting;
            }
            jg.writeRaw("}");
        }
    }
}

