/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.util;

import com.google.common.base.Suppliers;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class PhysicalCoreExecutor {
    private static volatile int physicalCoreCount = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private static final AtomicBoolean started = new AtomicBoolean(false);
    public static final Supplier<PhysicalCoreExecutor> instance = Suppliers.memoize(() -> {
        started.set(true);
        return new PhysicalCoreExecutor(physicalCoreCount);
    });
    private final ForkJoinPool pool;

    public static void overrideThreadCount(int threadCount) {
        if (!started.compareAndSet(false, true)) {
            throw new IllegalStateException("Executor already started");
        }
        physicalCoreCount = threadCount;
    }

    private PhysicalCoreExecutor(int cores) {
        assert (cores > 0 && cores <= Runtime.getRuntime().availableProcessors()) : "Invalid core count: " + cores;
        this.pool = new ForkJoinPool(cores, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
    }

    public void execute(Runnable run) {
        ((ForkJoinTask)this.pool.submit(run)).join();
    }

    public <T> T submit(Supplier<T> run) {
        return (T)((ForkJoinTask)this.pool.submit(run::get)).join();
    }

    public int getCoreCount() {
        return this.pool.getParallelism();
    }
}

