/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jctools.util.UnsafeAccess;

public class UnsafeDirectByteBuffer {
    private static final long addressOffset;
    public static final int CACHE_LINE_SIZE = 64;
    public static final int PAGE_SIZE;

    public static long getAddress(ByteBuffer buffy) {
        return UnsafeAccess.UNSAFE.getLong(buffy, addressOffset);
    }

    public static ByteBuffer allocateAlignedByteBuffer(int capacity, long align) {
        if (Long.bitCount(align) != 1) {
            throw new IllegalArgumentException("Alignment must be a power of 2");
        }
        ByteBuffer buffy = ByteBuffer.allocateDirect((int)((long)capacity + align));
        long address = UnsafeDirectByteBuffer.getAddress(buffy);
        if ((address & align - 1L) == 0L) {
            buffy.limit(capacity);
            ByteBuffer slice = buffy.slice().order(ByteOrder.nativeOrder());
            return slice;
        }
        int newPosition = (int)(align - (address & align - 1L));
        buffy.position(newPosition);
        int newLimit = newPosition + capacity;
        buffy.limit(newLimit);
        ByteBuffer slice = buffy.slice().order(ByteOrder.nativeOrder());
        return slice;
    }

    static {
        PAGE_SIZE = UnsafeAccess.UNSAFE.pageSize();
        try {
            addressOffset = UnsafeAccess.UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

