/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient.cert;

import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.CertificatesVerifier;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.cert.SafeSingleScheduleExecutor;
import com.wechat.pay.contrib.apache.httpclient.util.CertSerializeUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertManagerSingleton {
    private static final Logger log = LoggerFactory.getLogger(CertManagerSingleton.class);
    private static final String CERT_DOWNLOAD_PATH = "https://api.mch.weixin.qq.com/v3/certificates";
    private static final String SCHEDULE_UPDATE_CERT_THREAD_NAME = "scheduled_update_cert_thread";
    private static volatile CertManagerSingleton instance = null;
    private byte[] apiV3Key;
    private ConcurrentHashMap<BigInteger, X509Certificate> certificates;
    private Credentials credentials;
    private ScheduledExecutorService executor;

    private CertManagerSingleton() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CertManagerSingleton getInstance() {
        if (instance != null) return instance;
        Class<CertManagerSingleton> clazz = CertManagerSingleton.class;
        synchronized (CertManagerSingleton.class) {
            if (instance != null) return instance;
            instance = new CertManagerSingleton();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void init(Credentials credentials, byte[] apiV3Key, long minutesInterval) {
        if (credentials == null || apiV3Key.length == 0 || minutesInterval == 0L) {
            throw new IllegalArgumentException("credentials\u6216apiV3Key\u6216minutesInterval\u4e3a\u7a7a");
        }
        if (this.credentials == null || this.apiV3Key.length == 0 || this.executor == null || this.certificates == null) {
            this.credentials = credentials;
            this.apiV3Key = apiV3Key;
            this.executor = new SafeSingleScheduleExecutor();
            this.certificates = new ConcurrentHashMap();
            this.initCertificates();
            Runnable runnable = () -> {
                try {
                    Thread.currentThread().setName(SCHEDULE_UPDATE_CERT_THREAD_NAME);
                    log.info("Begin update Certificate.Date:{}", (Object)Instant.now());
                    this.updateCertificates();
                    log.info("Finish update Certificate.Date:{}", (Object)Instant.now());
                }
                catch (Throwable t) {
                    log.error("Update Certificate failed", t);
                }
            };
            this.executor.scheduleAtFixedRate(runnable, 0L, minutesInterval, TimeUnit.MINUTES);
        }
    }

    public void close() {
        if (this.executor == null) {
            throw new IllegalStateException("\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5\u521d\u59cb\u5316\u5b9e\u4f8b");
        }
        try {
            this.executor.shutdownNow();
        }
        catch (Exception e) {
            log.error("Executor shutdown now failed", (Throwable)e);
        }
    }

    public Map<BigInteger, X509Certificate> getCertificates() {
        if (this.certificates == null) {
            throw new IllegalStateException("\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5\u521d\u59cb\u5316\u5b9e\u4f8b");
        }
        return this.certificates;
    }

    public X509Certificate getLatestCertificate() {
        if (this.certificates == null) {
            throw new IllegalStateException("\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5\u521d\u59cb\u5316\u5b9e\u4f8b");
        }
        X509Certificate latestCert = null;
        for (X509Certificate x509Cert : this.certificates.values()) {
            if (latestCert != null && !x509Cert.getNotBefore().after(latestCert.getNotBefore())) continue;
            latestCert = x509Cert;
        }
        return latestCert;
    }

    private synchronized void downloadAndUpdateCert(Verifier verifier) {
        try (CloseableHttpClient httpClient = WechatPayHttpClientBuilder.create().withCredentials(this.credentials).withValidator(verifier == null ? response -> true : new WechatPay2Validator(verifier)).build();){
            HttpGet httpGet = new HttpGet(CERT_DOWNLOAD_PATH);
            httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
            try (CloseableHttpResponse response2 = httpClient.execute((HttpUriRequest)httpGet);){
                int statusCode = response2.getStatusLine().getStatusCode();
                String body = EntityUtils.toString((HttpEntity)response2.getEntity());
                if (statusCode == 200) {
                    Map<BigInteger, X509Certificate> newCertList = CertSerializeUtil.deserializeToCerts(this.apiV3Key, body);
                    if (newCertList.isEmpty()) {
                        log.warn("Cert list is empty");
                        return;
                    }
                    this.certificates.clear();
                    this.certificates.putAll(newCertList);
                } else {
                    log.error("Auto update cert failed, statusCode = {}, body = {}", (Object)statusCode, (Object)body);
                }
            }
        }
        catch (IOException | GeneralSecurityException e) {
            log.error("Download Certificate failed", (Throwable)e);
        }
    }

    private void initCertificates() {
        this.downloadAndUpdateCert(null);
    }

    private void updateCertificates() {
        CertificatesVerifier verifier = null;
        if (!this.certificates.isEmpty()) {
            verifier = new CertificatesVerifier(this.certificates);
        }
        this.downloadAndUpdateCert(verifier);
    }
}

