/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wechat.pay.contrib.apache.httpclient.util.AesUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;

public class CertSerializeUtil {
    public static Map<BigInteger, X509Certificate> deserializeToCerts(byte[] apiV3Key, String body) throws GeneralSecurityException, IOException {
        AesUtil aesUtil = new AesUtil(apiV3Key);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode dataNode = mapper.readTree(body).get("data");
        HashMap<BigInteger, X509Certificate> newCertList = new HashMap<BigInteger, X509Certificate>();
        if (dataNode != null) {
            int count = dataNode.size();
            for (int i = 0; i < count; ++i) {
                JsonNode node = dataNode.get(i).get("encrypt_certificate");
                String cert = aesUtil.decryptToString(node.get("associated_data").toString().replace("\"", "").getBytes(StandardCharsets.UTF_8), node.get("nonce").toString().replace("\"", "").getBytes(StandardCharsets.UTF_8), node.get("ciphertext").toString().replace("\"", ""));
                CertificateFactory cf = CertificateFactory.getInstance("X509");
                X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getBytes(StandardCharsets.UTF_8)));
                try {
                    x509Cert.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException ignored) {
                    continue;
                }
                newCertList.put(x509Cert.getSerialNumber(), x509Cert);
            }
        }
        return newCertList;
    }
}

