/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.certificate;

import com.wechat.pay.java.core.certificate.CertificateProvider;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class InMemoryCertificateProvider
implements CertificateProvider {
    private final ConcurrentHashMap<BigInteger, X509Certificate> certificates = new ConcurrentHashMap();
    private final X509Certificate availableCertificate;

    public InMemoryCertificateProvider(List<X509Certificate> certificates) {
        if (certificates.isEmpty()) {
            throw new IllegalArgumentException("The parameter list of constructor is empty.");
        }
        X509Certificate longest = null;
        for (X509Certificate item : certificates) {
            this.certificates.put(item.getSerialNumber(), item);
            if (longest != null && !item.getNotAfter().after(longest.getNotAfter())) continue;
            longest = item;
        }
        this.availableCertificate = longest;
    }

    @Override
    public X509Certificate getCertificate(String serialNumber) {
        BigInteger key = new BigInteger(serialNumber, 16);
        return this.certificates.get(key);
    }

    @Override
    public X509Certificate getAvailableCertificate() {
        return this.availableCertificate;
    }
}

