/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.notification;

import com.wechat.pay.java.core.cipher.AeadAesCipher;
import com.wechat.pay.java.core.cipher.AeadCipher;
import com.wechat.pay.java.core.notification.AbstractNotificationConfig;
import com.wechat.pay.java.core.util.PemUtil;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.Objects;

public final class RSAPublicKeyNotificationConfig
extends AbstractNotificationConfig {
    private RSAPublicKeyNotificationConfig(PublicKey publicKey, String publicKeyId, AeadCipher aeadCipher) {
        super("WECHATPAY2-SHA256-RSA2048", "AEAD_AES_256_GCM", publicKey, publicKeyId, aeadCipher);
    }

    public static class Builder {
        private byte[] apiV3Key;
        private PublicKey publicKey;
        private String publicKeyId;

        public Builder publicKey(String publicKey) {
            this.publicKey = PemUtil.loadPublicKeyFromString(publicKey);
            return this;
        }

        public Builder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public Builder publicKeyFromPath(String publicKeyPath) {
            this.publicKey = PemUtil.loadPublicKeyFromPath(publicKeyPath);
            return this;
        }

        public Builder apiV3Key(String apiV3Key) {
            this.apiV3Key = apiV3Key.getBytes(StandardCharsets.UTF_8);
            return this;
        }

        public Builder publicKeyId(String publicKeyId) {
            this.publicKeyId = publicKeyId;
            return this;
        }

        public RSAPublicKeyNotificationConfig build() {
            Objects.requireNonNull(this.publicKey);
            Objects.requireNonNull(this.publicKeyId);
            Objects.requireNonNull(this.apiV3Key);
            return new RSAPublicKeyNotificationConfig(this.publicKey, Objects.requireNonNull(this.publicKeyId), new AeadAesCipher(Objects.requireNonNull(this.apiV3Key)));
        }
    }
}

