/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.nacos;

import cn.hutool.core.util.StrUtil;
import com.github.xiaoymin.knife4j.aggre.core.ext.PoolingConnectionManager;
import com.github.xiaoymin.knife4j.aggre.core.pojo.BasicAuth;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosOpenApi
extends PoolingConnectionManager {
    private static final String NACOS_AUTH_API = "/v1/auth/login";
    Logger logger = LoggerFactory.getLogger(NacosOpenApi.class);
    private static final NacosOpenApi INSTANCE = new NacosOpenApi();

    private NacosOpenApi() {
    }

    public static NacosOpenApi me() {
        return INSTANCE;
    }

    public String getAccessToken(String serviceUrl, BasicAuth basicAuth) {
        if (serviceUrl == null) {
            throw new IllegalArgumentException("Nacos serviceUrl can't be Null!");
        }
        if (basicAuth == null) {
            throw new IllegalArgumentException("basicAuth can't be Null!");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get Nacos OpenApi accessToken,serviceUrl:{},argument:{}", (Object)serviceUrl, (Object)basicAuth.toString());
        }
        String api = serviceUrl + NACOS_AUTH_API;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Nacos OpenApi auth url:{}", (Object)api);
        }
        HttpPost post = new HttpPost(api);
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        pairs.add(new BasicNameValuePair("username", basicAuth.getUsername()));
        pairs.add(new BasicNameValuePair("password", basicAuth.getPassword()));
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, "UTF-8"));
            CloseableHttpResponse response = this.getClient().execute((HttpUriRequest)post);
            if (response != null) {
                int statusCode = response.getStatusLine().getStatusCode();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Nacos Response Status:{}", (Object)statusCode);
                }
                if (statusCode == 200) {
                    String content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    if (StrUtil.isNotBlank((CharSequence)content)) {
                        JsonElement accessTokenElement;
                        JsonElement jsonElement;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Response Content:{}", (Object)content);
                        }
                        if ((jsonElement = JsonParser.parseString((String)content)) != null && jsonElement.isJsonObject() && (accessTokenElement = jsonElement.getAsJsonObject().get("accessToken")) != null) {
                            return accessTokenElement.getAsString();
                        }
                    }
                } else {
                    post.abort();
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

