/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.polaris;

import cn.hutool.json.JSONObject;
import com.github.xiaoymin.knife4j.aggre.core.ext.PoolingConnectionManager;
import com.github.xiaoymin.knife4j.aggre.core.pojo.BasicAuth;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisOpenApi
extends PoolingConnectionManager {
    Logger logger = LoggerFactory.getLogger(PolarisOpenApi.class);
    private static final PolarisOpenApi INSTANCE = new PolarisOpenApi();
    private static final String LOGIN_API = "/core/v1/user/login";

    private PolarisOpenApi() {
    }

    public static PolarisOpenApi me() {
        return INSTANCE;
    }

    public String getJwtCookie(String serviceUrl, BasicAuth basicAuth) {
        if (serviceUrl == null) {
            throw new IllegalArgumentException("Polaris serviceUrl can't be Null!");
        }
        if (basicAuth == null) {
            throw new IllegalArgumentException("basicAuth can't be Null!");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get Polaris OpenApi jwtCookie,serviceUrl:{},argument:{}", (Object)serviceUrl, (Object)basicAuth);
        }
        String api = serviceUrl + LOGIN_API;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Polaris OpenApi auth url:{}", (Object)api);
        }
        HttpPost post = new HttpPost(api);
        post.setHeader("Content-Type", "application/json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.putOnce("name", (Object)basicAuth.getUsername());
        jsonObject.putOnce("password", (Object)basicAuth.getPassword());
        String body = jsonObject.toString();
        try {
            post.setEntity((HttpEntity)new StringEntity(body));
            CloseableHttpResponse response = this.getClient().execute((HttpUriRequest)post);
            if (response != null) {
                int statusCode = response.getStatusLine().getStatusCode();
                String content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                if (statusCode == 200) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Polaris OpenApi auth response status: {}, entity: {}", (Object)statusCode, (Object)content);
                    }
                    return response.getHeaders("Set-Cookie")[0].getValue();
                }
                post.abort();
                this.logger.warn("Polaris OpenApi auth response status: {}, entity: {}", (Object)statusCode, (Object)content);
            } else {
                this.logger.warn("Polaris OpenApi auth response is null");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

