/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.ObjectJudge;
import com.gomyck.util.log.logger.CkLogger;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CkBarCode {
    private static final Logger log = LoggerFactory.getLogger(CkBarCode.class);
    private static final ReentrantLock rl = new ReentrantLock(true);
    private static CkBarCode ckBarCode;
    private Adaptor adaptor = new Adaptor();

    private CkBarCode() {
    }

    public static CkBarCode init() {
        try {
            rl.lockInterruptibly();
            if (ckBarCode == null) {
                ckBarCode = new CkBarCode();
            }
        }
        catch (InterruptedException e) {
            log.error(CkLogger.getTrace(e));
        }
        finally {
            rl.unlock();
        }
        return ckBarCode;
    }

    public static CkBarCode init(Adaptor adaptor) {
        CkBarCode ckBarCode = new CkBarCode();
        ckBarCode.adaptor = adaptor;
        return ckBarCode;
    }

    public BufferedImage getBarCode(String vaNumber) {
        Code128Writer writer = new Code128Writer();
        BitMatrix bitMatrix = writer.encode(vaNumber, BarcodeFormat.CODE_128, this.adaptor.getWIDTH(), this.adaptor.getHEIGHT(), this.adaptor.getHints());
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    public BufferedImage getBarCodeWithWord(String vaNumber, String word) {
        return this.insertWords(this.getBarCode(vaNumber), word);
    }

    private BufferedImage insertWords(BufferedImage image, String words) {
        if (ObjectJudge.notNull((Object)words)) {
            BufferedImage outImage = new BufferedImage(this.adaptor.getWIDTH(), this.adaptor.getWORD_HEIGHT(), 1);
            Graphics2D g2d = outImage.createGraphics();
            CkBarCode.setGraphics2D(g2d);
            CkBarCode.setColorWhite(g2d);
            g2d.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
            Color color = new Color(0, 0, 0);
            g2d.setColor(color);
            g2d.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 18));
            int strWidth = g2d.getFontMetrics().stringWidth(words);
            int wordStartX = (this.adaptor.getWIDTH() - strWidth) / 2;
            int wordStartY = this.adaptor.getHEIGHT() + 20;
            g2d.drawString(words, wordStartX, wordStartY);
            g2d.dispose();
            outImage.flush();
            return outImage;
        }
        return null;
    }

    private static void setGraphics2D(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        BasicStroke s = new BasicStroke(1.0f, 1, 0);
        g2d.setStroke(s);
    }

    private static void setColorWhite(Graphics2D g2d) {
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, 600, 600);
        g2d.setColor(Color.BLACK);
    }

    public static class Adaptor {
        private int WIDTH = 300;
        private int HEIGHT = 50;
        private int WORD_HEIGHT = 75;
        private Map<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8);
            }
        };

        public int getWIDTH() {
            return this.WIDTH;
        }

        public int getHEIGHT() {
            return this.HEIGHT;
        }

        public int getWORD_HEIGHT() {
            return this.WORD_HEIGHT;
        }

        public Map<EncodeHintType, Object> getHints() {
            return this.hints;
        }

        public void setWIDTH(int WIDTH) {
            this.WIDTH = WIDTH;
        }

        public void setHEIGHT(int HEIGHT) {
            this.HEIGHT = HEIGHT;
        }

        public void setWORD_HEIGHT(int WORD_HEIGHT) {
            this.WORD_HEIGHT = WORD_HEIGHT;
        }

        public void setHints(Map<EncodeHintType, Object> hints) {
            this.hints = hints;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Adaptor)) {
                return false;
            }
            Adaptor other = (Adaptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWIDTH() != other.getWIDTH()) {
                return false;
            }
            if (this.getHEIGHT() != other.getHEIGHT()) {
                return false;
            }
            if (this.getWORD_HEIGHT() != other.getWORD_HEIGHT()) {
                return false;
            }
            Map<EncodeHintType, Object> this$hints = this.getHints();
            Map<EncodeHintType, Object> other$hints = other.getHints();
            return !(this$hints == null ? other$hints != null : !((Object)this$hints).equals(other$hints));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Adaptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWIDTH();
            result = result * 59 + this.getHEIGHT();
            result = result * 59 + this.getWORD_HEIGHT();
            Map<EncodeHintType, Object> $hints = this.getHints();
            result = result * 59 + ($hints == null ? 43 : ((Object)$hints).hashCode());
            return result;
        }

        public String toString() {
            return "CkBarCode.Adaptor(WIDTH=" + this.getWIDTH() + ", HEIGHT=" + this.getHEIGHT() + ", WORD_HEIGHT=" + this.getWORD_HEIGHT() + ", hints=" + this.getHints() + ")";
        }
    }
}

