/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.FieldUtil;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.log.logger.CkLogger;
import com.gomyck.util.serialize.CKJSON;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

public class CkBean {
    private static final Logger log = LoggerFactory.getLogger(CkBean.class);

    public static String[] getNullPropertyNames(Object source, Predicate<Object> predicate) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (!predicate.test(srcValue)) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static <T> List<T> copyProperties(Collection<Object> source, Class<T> clazz) {
        ArrayList list = new ArrayList();
        source.forEach(item -> {
            try {
                Object t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                BeanUtils.copyProperties((Object)item, t);
                list.add(t);
            }
            catch (Exception e) {
                log.error(CkLogger.getTrace(e));
            }
        });
        return list;
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])CkBean.getNullPropertyNames(source, o -> o == null || o.toString().trim().isEmpty()));
    }

    public static void copyPropertiesWithEmptyStr(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])CkBean.getNullPropertyNames(source, Objects::isNull));
    }

    public static void copyProperties(Object source, Object target, Predicate<Object> predicate) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])CkBean.getNullPropertyNames(source, predicate));
    }

    public static TreeMap beanToTreeMap(Object param) {
        TreeMap map = new TreeMap();
        CkBean.putIt(param, map, null);
        return map;
    }

    public static TreeMap beanToTreeMap(Object param, List<String> exclusive) {
        TreeMap map = new TreeMap();
        CkBean.putIt(param, map, exclusive);
        return map;
    }

    public static Map beanToHashMap(Object param) {
        HashMap map = new HashMap();
        CkBean.putIt(param, map, null);
        return map;
    }

    public static Map beanToHashMap(Object param, List<String> exclusive) {
        HashMap map = new HashMap();
        CkBean.putIt(param, map, exclusive);
        return map;
    }

    public static Map beanToLinkedMap(Object param) {
        LinkedHashMap map = new LinkedHashMap();
        CkBean.putIt(param, map, null);
        return map;
    }

    public static Map beanToLinkedMap(Object param, List<String> exclusive) {
        LinkedHashMap map = new LinkedHashMap();
        CkBean.putIt(param, map, exclusive);
        return map;
    }

    public static String beanToRequestBody(Object param) {
        return CkBean.beanToRequestBody(param, true, null);
    }

    public static String beanToRequestBody(Object param, boolean ifContainNull, List<String> exclusive) {
        if (param instanceof Map) {
            Map map = (Map)param;
            StringBuilder sb = new StringBuilder();
            map.keySet().forEach(e -> {
                String value = (String)map.get(e);
                if (ObjectJudge.notNull((Object)value)) {
                    sb.append(MessageFormat.format("{0}={1}&", e, value));
                } else if (ifContainNull) {
                    sb.append(MessageFormat.format("{0}=&", e));
                }
            });
            return sb.toString();
        }
        if (!FieldUtil.isBaseType(param)) {
            Class<?> clazz = param.getClass();
            List<Field> fields = FieldUtil.getAllFields(clazz);
            StringBuilder sb = new StringBuilder();
            for (Field field : fields) {
                String fieldName = field.getName();
                Method getMethod = FieldUtil.getMethod(clazz, fieldName);
                try {
                    Object value = getMethod.invoke(param, new Object[0]);
                    if (exclusive != null && exclusive.contains(fieldName)) continue;
                    if (ObjectJudge.notNull(value)) {
                        sb.append(MessageFormat.format("{0}={1}&", fieldName, CkBean.serialize(value, true)));
                        continue;
                    }
                    if (!ifContainNull || !ObjectJudge.isNull(value)) continue;
                    sb.append(MessageFormat.format("{0}=&", fieldName));
                }
                catch (Exception e2) {
                    log.debug("error convert bean: {} {}", (Object)param.getClass().getName(), (Object)e2);
                }
            }
            if (sb.length() > 0) {
                return sb.substring(0, sb.length() - 1);
            }
            return sb.toString();
        }
        return param.toString();
    }

    static void putIt(Object param, Map map, List<String> exclusive) {
        if (ObjectJudge.isNull(param)) {
            return;
        }
        Class<?> clazz = param.getClass();
        List<Field> fields = FieldUtil.getAllFields(clazz);
        for (Field field : fields) {
            String fieldName = field.getName();
            try {
                Method method = FieldUtil.getMethod(clazz, fieldName);
                Object value = method.invoke(param, new Object[0]);
                if (exclusive != null && exclusive.contains(fieldName)) continue;
                map.put(fieldName, value);
            }
            catch (Exception e) {
                log.debug("error convert bean: {}, {}", (Object)param.getClass().getName(), (Object)e.toString());
            }
        }
    }

    public static void requestParamToBean(String params, Object obj) {
        if (ObjectJudge.hasNull(params, obj)) {
            return;
        }
        Class<?> aClass = obj.getClass();
        String[] paramArr = params.split("&");
        Arrays.stream(paramArr).forEach(e -> {
            String[] p = e.split("=");
            String fieldName = p[0];
            String value = p.length > 1 ? p[1] : "";
            Method method = FieldUtil.setMethod(aClass, fieldName);
            try {
                method.invoke(obj, value);
            }
            catch (Exception exception) {
                log.info("fieldName can`t be find, {} in {}", (Object)fieldName, (Object)aClass.getSimpleName());
            }
        });
    }

    public static Object serialize(Object o, boolean includeArrays) {
        if (o instanceof Collection && !includeArrays) {
            return o;
        }
        if (FieldUtil.isBaseType(o) || FieldUtil.isWrapperBaseType(o) || o instanceof String) {
            return o;
        }
        String result = CKJSON.getInstance().toJsonString(o);
        if (o.getClass().isAssignableFrom(String[].class)) {
            result = result.replaceAll("(\\[\")", "[").replaceAll("(\"])", "]").replaceAll("(\",\")", ",");
        }
        return result;
    }

    public static Object deserialize(String value, Class<?> clazz) {
        if (value == null) {
            return null;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return CKJSON.getInstance().parseArray(value, clazz);
        }
        if (clazz.isArray()) {
            return value.substring(1).substring(0, value.length() - 2).split(",");
        }
        if (clazz != String.class) {
            return CKJSON.getInstance().parseObject(value, clazz);
        }
        return clazz.cast(value);
    }
}

