/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.log.logger.CkLogger;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CkDate {
    private static final Logger log = LoggerFactory.getLogger(CkDate.class);
    public static final String CN_DATE_FORMAT_1 = "yyyy-MM-dd";
    public static final String CN_DATE_FORMAT_2 = "yyyy/MM/dd";
    public static final String CN_DATE_FORMAT_3 = "yyyyMMdd";
    public static final String CN_SHORT_DATE_FORMAT_1 = "yy-MM-dd";
    public static final String CN_SHORT_DATE_FORMAT_2 = "yy/MM/dd";
    public static final String CN_DATETIME_FORMAT_1 = "yyyy-MM-dd HH:mm:ss";
    public static final String CN_DATETIME_FORMAT_2 = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String CN_DATETIME_FORMAT_3 = "yyyyMMddHHmmss";
    public static final String CN_DATETIME_FORMAT_4 = "yyyyMMddHHmmssSSS";
    public static final String TIME_FORMAT_1 = "HH:mm:ss";
    public static final String TIME_FORMAT_2 = "HH:mm:ss.SSS";
    public static final String TIME_MIN = "00:00:00";
    public static final String TIME_MAX = "23:59:59";

    public static Date dateBound(Date date, boolean isMin) {
        String DATETIME_MIN_FORMAT = "yyyy-MM-dd 00:00:00";
        String DATETIME_MAX_FORMAT = "yyyy-MM-dd 23:59:59";
        SimpleDateFormat sdf = new SimpleDateFormat(isMin ? DATETIME_MIN_FORMAT : DATETIME_MAX_FORMAT);
        String str = sdf.format(date);
        return CkDate.str2Date(str, CN_DATETIME_FORMAT_1);
    }

    public static String now2Str(String formatter) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatter);
        Date date = new Date();
        String str = sdf.format(date);
        return str;
    }

    public static String getWeek(Date date) {
        String[] weekDays = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static Date str2Date(String strDate, String fromFormat) {
        SimpleDateFormat f = new SimpleDateFormat(fromFormat);
        Date date = null;
        try {
            date = f.parse(strDate);
        }
        catch (ParseException e) {
            log.error(CkLogger.getTrace(e));
        }
        return date;
    }

    public static String date2Str(Date date, String fromFormat) {
        SimpleDateFormat f = new SimpleDateFormat(fromFormat);
        return f.format(date);
    }

    public static String getDay4Week(String date) {
        String result;
        LocalDate localDate = LocalDate.parse(date, DateTimeFormatter.ofPattern(CN_DATE_FORMAT_1));
        int day = localDate.getDayOfWeek().getValue();
        switch (day) {
            case 1: {
                result = "\u661f\u671f\u4e00";
                break;
            }
            case 2: {
                result = "\u661f\u671f\u4e8c";
                break;
            }
            case 3: {
                result = "\u661f\u671f\u4e09";
                break;
            }
            case 4: {
                result = "\u661f\u671f\u56db";
                break;
            }
            case 5: {
                result = "\u661f\u671f\u4e94";
                break;
            }
            case 6: {
                result = "\u661f\u671f\u516d";
                break;
            }
            default: {
                result = "\u661f\u671f\u65e5";
            }
        }
        return result;
    }

    public static List<String> getWeekends(int year) {
        ArrayList<String> list = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(CN_DATE_FORMAT_1);
        Calendar cal = Calendar.getInstance(Locale.CHINA);
        cal.set(year, 0, 1);
        for (int day = 1; day <= cal.getActualMaximum(6); ++day) {
            cal.set(6, day);
            int weekDay = cal.get(7);
            if (weekDay == 7 || weekDay == 1) {
                list.add(sdf.format(cal.getTime()) + " " + CkDate.getDay4Week(sdf.format(cal.getTime())));
                continue;
            }
            list.add(sdf.format(cal.getTime()) + " " + CkDate.getDay4Week(sdf.format(cal.getTime())));
        }
        return list;
    }

    public static Date dateOperate(Date date, int amount, int calendarType) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(calendarType, amount);
        return cal.getTime();
    }

    public static Boolean compareDate(String date) {
        Date dt2;
        SimpleDateFormat df = new SimpleDateFormat(CN_DATETIME_FORMAT_1);
        Date dt1 = new Date();
        try {
            dt2 = df.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        return dt1.getTime() > dt2.getTime();
    }

    public static Boolean compareDate(String date1, String date2) {
        Date dt2;
        Date dt1;
        SimpleDateFormat df = new SimpleDateFormat(CN_DATETIME_FORMAT_1);
        try {
            dt1 = df.parse(date1);
            dt2 = df.parse(date2);
        }
        catch (ParseException e) {
            log.error(CkLogger.getTrace(e));
            return false;
        }
        return dt1.getTime() > dt2.getTime();
    }

    public static String getWeekDay(int weekNum) {
        String[][] day = new String[][]{{"Monday", "\u661f\u671f\u4e00"}, {"Tuesday", "\u661f\u671f\u4e8c"}, {"Wednesday", "\u661f\u671f\u4e09"}, {"Thursday", "\u661f\u671f\u56db"}, {"Friday", "\u661f\u671f\u4e94"}, {"Saturday", "\u661f\u671f\u516d"}, {"Sunday", "\u661f\u671f\u65e5"}};
        return day[weekNum - 1][1];
    }

    public static List<String> getAllWeekInRange(String dateBegin, String dateEnd, String ... week) {
        ArrayList<String> dayTime = new ArrayList<String>();
        List<String> dayListInPeriod = CkDate.getAllDayInRange(dateBegin, dateEnd);
        dayListInPeriod.forEach(e -> {
            for (String s : week) {
                if (!s.startsWith(CkDate.getDay4Week(e))) continue;
                dayTime.add(MessageFormat.format("{0} {1}", e, s));
            }
        });
        return dayTime;
    }

    public static List<String> getAllDayInRange(String beginDate, String endDate) {
        ArrayList<String> list = new ArrayList<String>();
        Calendar calendar_begin = Calendar.getInstance();
        calendar_begin.setTime(CkDate.str2Date(beginDate, CN_DATE_FORMAT_1));
        Calendar calendar_end = Calendar.getInstance();
        calendar_end.setTime(CkDate.str2Date(endDate, CN_DATE_FORMAT_1));
        do {
            list.add(CkDate.date2Str(calendar_begin.getTime(), CN_DATE_FORMAT_1));
            calendar_begin.add(5, 1);
        } while (!calendar_begin.after(calendar_end));
        return list;
    }
}

