/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.CkContentType;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.log.logger.CkLogger;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CkEMail {
    private static final Logger log = LoggerFactory.getLogger(CkEMail.class);
    private static final Logger logger = LoggerFactory.getLogger(CkEMail.class);

    public static Session initSession(final String userName, final String password, SmtpSetting smtpSetting) {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", smtpSetting.getHost());
        props.setProperty("mail.smtp.auth", smtpSetting.getAuth().toString());
        props.setProperty("mail.debug", smtpSetting.getDebug().toString());
        if (smtpSetting.getSsl().booleanValue()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            props.setProperty("mail.smtp.ssl.enable", "true");
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.port", smtpSetting.getSslPort().toString());
            props.setProperty("mail.smtp.socketFactory.port", smtpSetting.getSslPort().toString());
        }
        return Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password);
            }
        });
    }

    public static void sendEmail(UserInfo userInfo, ReceiverUserInfo receiverUserInfo, EmailInfo emailInfo) throws MessagingException {
        int nAddresses;
        InternetAddress[] copyTo;
        int i;
        MimeMessage message = new MimeMessage(userInfo.getSession());
        if (!ObjectJudge.isNull((Object)userInfo.getUserName())) {
            InternetAddress sentFrom = new InternetAddress(userInfo.getUserName());
            message.setFrom((Address)sentFrom);
            if (logger.isDebugEnabled()) {
                logger.debug("e-mail sender: " + sentFrom);
            }
        }
        String[] receivers = receiverUserInfo.getReceivers();
        String[] copy = receiverUserInfo.getCopy();
        String[] secretCopy = receiverUserInfo.getSecretCopy();
        if (receivers != null) {
            InternetAddress[] sendTo = new InternetAddress[receivers.length];
            for (i = 0; i < receivers.length; ++i) {
                sendTo[i] = new InternetAddress(receivers[i]);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("sending e-mail receivers: " + receivers[i]);
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])sendTo);
        }
        if (copy != null) {
            copyTo = new InternetAddress[copy.length];
            for (i = 0; i < copy.length; ++i) {
                copyTo[i] = new InternetAddress(copy[i]);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("copying e-mail receivers: " + copy[i]);
            }
            message.setRecipients(Message.RecipientType.CC, (Address[])copyTo);
        }
        if (secretCopy != null) {
            copyTo = new InternetAddress[secretCopy.length];
            for (i = 0; i < secretCopy.length; ++i) {
                copyTo[i] = new InternetAddress(secretCopy[i]);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("blind copying e-mail receivers: " + secretCopy[i]);
            }
            message.setRecipients(Message.RecipientType.BCC, (Address[])copyTo);
        }
        message.setSubject(emailInfo.getEmailTitle() == null ? "hi~" : emailInfo.getEmailTitle());
        message.setSentDate(new Date());
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart content = new MimeBodyPart();
        if (ObjectJudge.notNull(emailInfo.getContent()) && emailInfo.getContent() instanceof String) {
            content.setContent((Object)emailInfo.getContent().toString().concat("\n\n"), emailInfo.getMimeType().getTypeValue(emailInfo.getCharset()));
        } else {
            content.setContent(emailInfo.getContent(), emailInfo.getMimeType().getTypeValue(emailInfo.getCharset()));
        }
        multipart.addBodyPart((BodyPart)content);
        File[] attachFile = emailInfo.getAttachFile();
        if (attachFile != null) {
            Arrays.stream(attachFile).forEach(e -> {
                MimeBodyPart fileInfo = new MimeBodyPart();
                try {
                    fileInfo.setFileName(e.getName());
                    fileInfo.setDataHandler(new DataHandler((DataSource)new FileDataSource(e)));
                    multipart.addBodyPart((BodyPart)fileInfo);
                }
                catch (MessagingException messagingException) {
                    log.error(CkLogger.getTrace(messagingException));
                }
            });
        }
        message.setContent((Multipart)multipart);
        Address[] remainingAddresses = message.getAllRecipients();
        boolean bFailedToSome = false;
        SendFailedException sendex = new SendFailedException("Unable receivers send message receivers some recipients");
        do {
            nAddresses = remainingAddresses.length;
            try {
                Transport.send((Message)message, (Address[])remainingAddresses);
            }
            catch (SendFailedException ex) {
                bFailedToSome = true;
                sendex.setNextException((Exception)((Object)ex));
                remainingAddresses = ex.getValidUnsentAddresses();
            }
        } while (remainingAddresses != null && remainingAddresses.length > 0 && remainingAddresses.length != nAddresses);
        if (bFailedToSome) {
            throw sendex;
        }
    }

    public static class EmailInfo {
        private final String emailTitle;
        private final Object content;
        private final File[] attachFile;
        private final CkContentType mimeType;
        private final Charset charset = StandardCharsets.UTF_8;

        EmailInfo(String emailTitle, Object content, File[] attachFile, CkContentType mimeType) {
            this.emailTitle = emailTitle;
            this.content = content;
            this.attachFile = attachFile;
            this.mimeType = mimeType;
        }

        public static EmailInfoBuilder builder() {
            return new EmailInfoBuilder();
        }

        public String getEmailTitle() {
            return this.emailTitle;
        }

        public Object getContent() {
            return this.content;
        }

        public File[] getAttachFile() {
            return this.attachFile;
        }

        public CkContentType getMimeType() {
            return this.mimeType;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EmailInfo)) {
                return false;
            }
            EmailInfo other = (EmailInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$emailTitle = this.getEmailTitle();
            String other$emailTitle = other.getEmailTitle();
            if (this$emailTitle == null ? other$emailTitle != null : !this$emailTitle.equals(other$emailTitle)) {
                return false;
            }
            Object this$content = this.getContent();
            Object other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAttachFile(), other.getAttachFile())) {
                return false;
            }
            CkContentType this$mimeType = this.getMimeType();
            CkContentType other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !((Object)((Object)this$mimeType)).equals((Object)other$mimeType)) {
                return false;
            }
            Charset this$charset = this.getCharset();
            Charset other$charset = other.getCharset();
            return !(this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EmailInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $emailTitle = this.getEmailTitle();
            result = result * 59 + ($emailTitle == null ? 43 : $emailTitle.hashCode());
            Object $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getAttachFile());
            CkContentType $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : ((Object)((Object)$mimeType)).hashCode());
            Charset $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
            return result;
        }

        public String toString() {
            return "CkEMail.EmailInfo(emailTitle=" + this.getEmailTitle() + ", content=" + this.getContent() + ", attachFile=" + Arrays.deepToString(this.getAttachFile()) + ", mimeType=" + (Object)((Object)this.getMimeType()) + ", charset=" + this.getCharset() + ")";
        }

        public static class EmailInfoBuilder {
            private String emailTitle;
            private Object content;
            private File[] attachFile;
            private CkContentType mimeType;

            EmailInfoBuilder() {
            }

            public EmailInfoBuilder emailTitle(String emailTitle) {
                this.emailTitle = emailTitle;
                return this;
            }

            public EmailInfoBuilder content(Object content) {
                this.content = content;
                return this;
            }

            public EmailInfoBuilder attachFile(File[] attachFile) {
                this.attachFile = attachFile;
                return this;
            }

            public EmailInfoBuilder mimeType(CkContentType mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            public EmailInfo build() {
                return new EmailInfo(this.emailTitle, this.content, this.attachFile, this.mimeType);
            }

            public String toString() {
                return "CkEMail.EmailInfo.EmailInfoBuilder(emailTitle=" + this.emailTitle + ", content=" + this.content + ", attachFile=" + Arrays.deepToString(this.attachFile) + ", mimeType=" + (Object)((Object)this.mimeType) + ")";
            }
        }
    }

    public static class ReceiverUserInfo {
        final String[] receivers;
        final String[] copy;
        final String[] secretCopy;

        ReceiverUserInfo(String[] receivers, String[] copy, String[] secretCopy) {
            this.receivers = receivers;
            this.copy = copy;
            this.secretCopy = secretCopy;
        }

        public static ReceiverUserInfoBuilder builder() {
            return new ReceiverUserInfoBuilder();
        }

        public String[] getReceivers() {
            return this.receivers;
        }

        public String[] getCopy() {
            return this.copy;
        }

        public String[] getSecretCopy() {
            return this.secretCopy;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReceiverUserInfo)) {
                return false;
            }
            ReceiverUserInfo other = (ReceiverUserInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getReceivers(), other.getReceivers())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getCopy(), other.getCopy())) {
                return false;
            }
            return Arrays.deepEquals(this.getSecretCopy(), other.getSecretCopy());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReceiverUserInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getReceivers());
            result = result * 59 + Arrays.deepHashCode(this.getCopy());
            result = result * 59 + Arrays.deepHashCode(this.getSecretCopy());
            return result;
        }

        public String toString() {
            return "CkEMail.ReceiverUserInfo(receivers=" + Arrays.deepToString(this.getReceivers()) + ", copy=" + Arrays.deepToString(this.getCopy()) + ", secretCopy=" + Arrays.deepToString(this.getSecretCopy()) + ")";
        }

        public static class ReceiverUserInfoBuilder {
            private String[] receivers;
            private String[] copy;
            private String[] secretCopy;

            ReceiverUserInfoBuilder() {
            }

            public ReceiverUserInfoBuilder receivers(String[] receivers) {
                this.receivers = receivers;
                return this;
            }

            public ReceiverUserInfoBuilder copy(String[] copy) {
                this.copy = copy;
                return this;
            }

            public ReceiverUserInfoBuilder secretCopy(String[] secretCopy) {
                this.secretCopy = secretCopy;
                return this;
            }

            public ReceiverUserInfo build() {
                return new ReceiverUserInfo(this.receivers, this.copy, this.secretCopy);
            }

            public String toString() {
                return "CkEMail.ReceiverUserInfo.ReceiverUserInfoBuilder(receivers=" + Arrays.deepToString(this.receivers) + ", copy=" + Arrays.deepToString(this.copy) + ", secretCopy=" + Arrays.deepToString(this.secretCopy) + ")";
            }
        }
    }

    public static class UserInfo {
        private final String userName;
        private final Session session;

        UserInfo(String userName, Session session) {
            this.userName = userName;
            this.session = session;
        }

        public static UserInfoBuilder builder() {
            return new UserInfoBuilder();
        }

        public String getUserName() {
            return this.userName;
        }

        public Session getSession() {
            return this.session;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserInfo)) {
                return false;
            }
            UserInfo other = (UserInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            Session this$session = this.getSession();
            Session other$session = other.getSession();
            return !(this$session == null ? other$session != null : !this$session.equals(other$session));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            Session $session = this.getSession();
            result = result * 59 + ($session == null ? 43 : $session.hashCode());
            return result;
        }

        public String toString() {
            return "CkEMail.UserInfo(userName=" + this.getUserName() + ", session=" + this.getSession() + ")";
        }

        public static class UserInfoBuilder {
            private String userName;
            private Session session;

            UserInfoBuilder() {
            }

            public UserInfoBuilder userName(String userName) {
                this.userName = userName;
                return this;
            }

            public UserInfoBuilder session(Session session) {
                this.session = session;
                return this;
            }

            public UserInfo build() {
                return new UserInfo(this.userName, this.session);
            }

            public String toString() {
                return "CkEMail.UserInfo.UserInfoBuilder(userName=" + this.userName + ", session=" + this.session + ")";
            }
        }
    }

    public static class SmtpSetting {
        private String host;
        private Boolean auth = true;
        private Boolean ssl = false;
        private Boolean debug = false;
        private Integer sslPort = 994;

        public String getHost() {
            return this.host;
        }

        public Boolean getAuth() {
            return this.auth;
        }

        public Boolean getSsl() {
            return this.ssl;
        }

        public Boolean getDebug() {
            return this.debug;
        }

        public Integer getSslPort() {
            return this.sslPort;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setAuth(Boolean auth) {
            this.auth = auth;
        }

        public void setSsl(Boolean ssl) {
            this.ssl = ssl;
        }

        public void setDebug(Boolean debug) {
            this.debug = debug;
        }

        public void setSslPort(Integer sslPort) {
            this.sslPort = sslPort;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SmtpSetting)) {
                return false;
            }
            SmtpSetting other = (SmtpSetting)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$auth = this.getAuth();
            Boolean other$auth = other.getAuth();
            if (this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth)) {
                return false;
            }
            Boolean this$ssl = this.getSsl();
            Boolean other$ssl = other.getSsl();
            if (this$ssl == null ? other$ssl != null : !((Object)this$ssl).equals(other$ssl)) {
                return false;
            }
            Boolean this$debug = this.getDebug();
            Boolean other$debug = other.getDebug();
            if (this$debug == null ? other$debug != null : !((Object)this$debug).equals(other$debug)) {
                return false;
            }
            Integer this$sslPort = this.getSslPort();
            Integer other$sslPort = other.getSslPort();
            if (this$sslPort == null ? other$sslPort != null : !((Object)this$sslPort).equals(other$sslPort)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SmtpSetting;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $auth = this.getAuth();
            result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
            Boolean $ssl = this.getSsl();
            result = result * 59 + ($ssl == null ? 43 : ((Object)$ssl).hashCode());
            Boolean $debug = this.getDebug();
            result = result * 59 + ($debug == null ? 43 : ((Object)$debug).hashCode());
            Integer $sslPort = this.getSslPort();
            result = result * 59 + ($sslPort == null ? 43 : ((Object)$sslPort).hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "CkEMail.SmtpSetting(host=" + this.getHost() + ", auth=" + this.getAuth() + ", ssl=" + this.getSsl() + ", debug=" + this.getDebug() + ", sslPort=" + this.getSslPort() + ")";
        }
    }
}

