/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.DataFilter;
import com.gomyck.util.FieldUtil;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.log.logger.CkLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CkExcel {
    private static final Logger log = LoggerFactory.getLogger(CkExcel.class);
    private String downloadSuffix = "xls";
    private Workbook workBook = null;
    private int sheetIndex = 0;
    private int rowIndex = -1;
    private int cellIndex = -1;
    private int dataSheetIndex = -1;
    private final List<String[]> dataList = new ArrayList<String[]>();
    private final ExcelType excelType;
    private int placeHolderRow = -1;
    private List<String> placeHolder = null;
    private final String XH_NAME = "xh";
    private Map<String, String> FIX_COL_INFO;

    public CkExcel(ExcelType type) {
        if ("xls".equals(type.name())) {
            this.workBook = new HSSFWorkbook();
            this.workBook.createSheet().createRow(0);
            this.downloadSuffix = type.name();
        } else if ("xlsx".equals(type.name())) {
            this.workBook = new XSSFWorkbook();
            this.workBook.createSheet().createRow(0);
            this.downloadSuffix = type.name();
        } else {
            throw new RuntimeException("\u6587\u6863\u683c\u5f0f\u9519\u8bef");
        }
        this.excelType = type;
    }

    public CkExcel(ExcelType type, InputStream inputStream) {
        if (inputStream == null) {
            throw new RuntimeException("file can not be null !");
        }
        try {
            this.workBook = WorkbookFactory.create((InputStream)inputStream);
            this.downloadSuffix = type.name();
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
        }
        this.excelType = type;
    }

    public synchronized List<String[]> getAllData() {
        this.dataList.clear();
        int columnNum = 0;
        Sheet sheet = this.workBook.getSheetAt(this.sheetIndex);
        if (sheet.getRow(0) != null) {
            columnNum = sheet.getRow(0).getLastCellNum() - sheet.getRow(0).getFirstCellNum();
        }
        if (columnNum <= 0) {
            return new ArrayList<String[]>();
        }
        for (Row row : sheet) {
            String[] singleRow = new String[columnNum];
            block7: for (int i = 0; i < columnNum; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    singleRow[i] = "";
                    continue;
                }
                switch (cell.getCellType()) {
                    case BOOLEAN: {
                        singleRow[i] = Boolean.toString(cell.getBooleanCellValue());
                        continue block7;
                    }
                    case NUMERIC: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            singleRow[i] = DataFilter.toString(cell.getDateCellValue());
                            continue block7;
                        }
                        String temp = DataFilter.toString(cell.getNumericCellValue());
                        if (temp.contains(".")) {
                            singleRow[i] = String.valueOf(new Double(temp)).trim();
                            continue block7;
                        }
                        singleRow[i] = temp.trim();
                        continue block7;
                    }
                    case STRING: {
                        singleRow[i] = cell.getStringCellValue().trim();
                        continue block7;
                    }
                    case FORMULA: {
                        singleRow[i] = cell.getCellFormula();
                        if (singleRow[i] == null) continue block7;
                        singleRow[i] = singleRow[i].replaceAll("#N/A", "").trim();
                        continue block7;
                    }
                    default: {
                        singleRow[i] = "";
                    }
                }
            }
            this.dataList.add(singleRow);
        }
        this.dataSheetIndex = this.sheetIndex;
        return new ArrayList<String[]>(this.dataList);
    }

    public int getMaxRowNum() {
        Sheet sheet = this.workBook.getSheetAt(this.sheetIndex);
        return sheet.getLastRowNum() + 1;
    }

    public int getMaxColumnNum() {
        Sheet sheet = this.workBook.getSheetAt(this.sheetIndex);
        Row row = sheet.getRow(0);
        if (row != null && row.getLastCellNum() > 0) {
            return row.getLastCellNum();
        }
        return 0;
    }

    public String[] getRowData(int rowIndex) {
        if (this.dataSheetIndex != this.sheetIndex) {
            this.getAllData();
        }
        if (rowIndex > this.getMaxRowNum() || this.dataList.size() <= 0) {
            return new String[0];
        }
        return this.dataList.get(rowIndex);
    }

    public String[] getColumnData(int colIndex, int beginRowIndex) {
        if (this.dataSheetIndex != this.sheetIndex) {
            this.getAllData();
        }
        String[] dataArray = null;
        if (colIndex > this.getMaxColumnNum() || this.dataList.size() <= 0) {
            return new String[0];
        }
        dataArray = new String[this.getMaxRowNum() - beginRowIndex];
        int index = 0;
        for (int i = beginRowIndex; i < this.dataList.size(); ++i) {
            String[] rowData = this.dataList.get(i);
            if (rowData == null) continue;
            dataArray[index] = rowData[colIndex];
            ++index;
        }
        return dataArray;
    }

    public void reload() {
        this.getAllData();
    }

    public CkExcel addSheet() {
        return this.addSheet(true);
    }

    public CkExcel addSheet(boolean indexIncrease) {
        this.getWorkBook().createSheet();
        if (indexIncrease) {
            this.sheetIndex = this.workBook.getNumberOfSheets() - 1;
        }
        return this;
    }

    public CkExcel addRow() {
        return this.addRow(true, false);
    }

    public CkExcel addRow(boolean indexIncrease) {
        return this.addRow(indexIncrease, false);
    }

    public CkExcel addRow(boolean indexIncrease, boolean replace) {
        this.checkSheet();
        if (indexIncrease) {
            ++this.rowIndex;
        }
        if (!replace && this.getWorkBook().getSheetAt(this.sheetIndex).getRow(this.rowIndex) != null) {
            int lastRowNo = this.getWorkBook().getSheetAt(this.sheetIndex).getLastRowNum();
            this.getWorkBook().getSheetAt(this.sheetIndex).shiftRows(this.rowIndex, lastRowNo, 1, true, true);
        }
        this.getWorkBook().getSheetAt(this.sheetIndex).createRow(this.rowIndex);
        return this;
    }

    public CkExcel addCell() {
        ++this.cellIndex;
        this.checkSheet();
        this.checkRow();
        while (this.getWorkBook().getSheetAt(this.sheetIndex).getRow(this.rowIndex).getCell(this.cellIndex) == null) {
            this.getWorkBook().getSheetAt(this.sheetIndex).getRow(this.rowIndex).createCell(this.cellIndex);
        }
        return this;
    }

    private void checkSheet() {
        while (this.getWorkBook().getSheetAt(this.sheetIndex) == null) {
            this.addSheet(false);
        }
    }

    private void checkRow() {
        while (this.getWorkBook().getSheetAt(this.sheetIndex).getRow(this.rowIndex) == null) {
            this.addRow(false);
        }
    }

    public CkExcel skipCell() {
        ++this.cellIndex;
        return this;
    }

    public CkExcel currentLocation(int sheetIndex, int rowIndex, int cellIndex) {
        this.sheetIndex = sheetIndex;
        this.rowIndex = rowIndex;
        this.cellIndex = cellIndex;
        return this;
    }

    public CkExcel cellVal(String cellValue) {
        if (this.rowIndex == -1) {
            throw new RuntimeException("please assign rowIndex");
        }
        if (this.cellIndex == -1) {
            throw new RuntimeException("please assign cellIndex");
        }
        try {
            this.getWorkBook().getSheetAt(this.sheetIndex).getRow(this.rowIndex).getCell(this.cellIndex).setCellValue(cellValue);
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
        }
        return this;
    }

    public CkExcel cellStyle(CellStyle style) {
        if (this.rowIndex == -1) {
            throw new RuntimeException("please assign rowIndex");
        }
        if (this.cellIndex == -1) {
            throw new RuntimeException("please assign cellIndex");
        }
        try {
            this.getWorkBook().getSheetAt(this.sheetIndex).getRow(this.rowIndex).getCell(this.cellIndex).setCellStyle(style);
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
        }
        return this;
    }

    public void index2LeftTop() {
        this.currentLocation(this.sheetIndex, -1, -1);
    }

    public CkExcel setFixColInfo(Map<String, String> fixColInfo) {
        this.FIX_COL_INFO = fixColInfo;
        return this;
    }

    public CkExcel setPlaceHolderRow(int placeHolderRow) {
        this.placeHolderRow = placeHolderRow;
        try {
            String[] rowData = this.getRowData(this.placeHolderRow);
            this.placeHolder = Arrays.asList(rowData);
            this.workBook.getSheetAt(this.getSheetIndex()).removeRow(this.getWorkBook().getSheetAt(this.getSheetIndex()).getRow(this.placeHolderRow));
            return this;
        }
        catch (Exception e) {
            this.placeHolderRow = -1;
            return this;
        }
    }

    public Workbook generateByCurrentWorkBook(List<? extends Object> param, Set<CkCellStyle> styles) {
        if (Objects.isNull(param) || param.isEmpty()) {
            return this.workBook;
        }
        this.initPlaceRowInfo(param);
        if (this.placeHolderRow < 0) {
            throw new RuntimeException("placeHolderRow must be not null");
        }
        this.setRowIndex(this.placeHolderRow);
        AtomicInteger xh = new AtomicInteger();
        this.currentLocation(this.sheetIndex, this.placeHolderRow, -1);
        for (String s : this.placeHolder) {
            this.addCell().cellVal(DataFilter.toString(s));
        }
        param.forEach(e -> {
            if (e == null) {
                return;
            }
            xh.getAndIncrement();
            this.currentLocation(this.sheetIndex, this.rowIndex, -1).addRow();
            if (e instanceof Map) {
                Map result = (Map)e;
                for (String ph : this.placeHolder) {
                    if (ObjectJudge.isNull((Object)ph)) {
                        this.addCell().cellVal("");
                        continue;
                    }
                    if (this.FIX_COL_INFO != null && ObjectJudge.notNull((Object)this.FIX_COL_INFO.get(ph))) {
                        this.addCell().cellVal(this.FIX_COL_INFO.get(ph));
                    } else if (result.containsKey(ph)) {
                        this.addCell().cellVal(DataFilter.toString(result.get(ph)));
                    } else if ("xh".equals(ph)) {
                        this.addCell().cellVal(DataFilter.toString(xh.get()));
                    } else {
                        this.addCell().cellVal(ph);
                    }
                    if (styles == null) continue;
                    Optional<CkCellStyle> any = styles.stream().filter(x -> x.equals(ph)).findAny();
                    any.ifPresent(ckCellStyle -> this.cellStyle(ckCellStyle.getStyle()));
                }
            } else if (!FieldUtil.isBaseType(e)) {
                for (String ph : this.placeHolder) {
                    if (ObjectJudge.isNull((Object)ph)) {
                        this.addCell().cellVal("");
                        continue;
                    }
                    Method getMethod = FieldUtil.getMethod(e.getClass(), ph);
                    if (this.FIX_COL_INFO != null && ObjectJudge.notNull((Object)this.FIX_COL_INFO.get(ph))) {
                        this.addCell().cellVal(this.FIX_COL_INFO.get(ph));
                    } else if (getMethod != null) {
                        try {
                            this.addCell().cellVal(DataFilter.toString(getMethod.invoke(e, new Object[0])));
                        }
                        catch (Exception any) {}
                    } else if ("xh".equals(ph)) {
                        this.addCell().cellVal(DataFilter.toString(DataFilter.toString(xh.get())));
                    } else {
                        this.addCell().cellVal(ph);
                    }
                    if (styles == null) continue;
                    Optional<CkCellStyle> any = styles.stream().filter(x -> x.equals(ph)).findAny();
                    any.ifPresent(ckCellStyle -> this.cellStyle(ckCellStyle.getStyle()));
                }
            } else {
                throw new RuntimeException("param generic type can not be base type...");
            }
        });
        return this.workBook;
    }

    private void initPlaceRowInfo(List<?> param) {
        if (this.placeHolderRow == -1) {
            Object o = param.get(0);
            if (o instanceof Map) {
                Set strings = ((Map)o).keySet();
                this.placeHolderRow = 0;
                this.placeHolder = new ArrayList(strings);
            } else if (!FieldUtil.isBaseType(o)) {
                List<Field> allFields = FieldUtil.getAllFields(o.getClass());
                this.placeHolderRow = 0;
                this.placeHolder = new ArrayList<String>();
                allFields.forEach(e -> this.placeHolder.add(e.getName()));
            }
        }
    }

    public Workbook generateByCurrentWorkBook(List<? extends Object> param) {
        return this.generateByCurrentWorkBook(param, null);
    }

    public byte[] getXlsxContentXml() {
        if (!this.excelType.equals((Object)ExcelType.xlsx)) {
            return null;
        }
        XSSFWorkbook workBook = (XSSFWorkbook)this.getWorkBook();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            workBook.getSharedStringSource().writeTo((OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            log.error(CkLogger.getTrace(e));
            return null;
        }
    }

    public void setXlsxContentXml(byte[] content) {
        if (!this.excelType.equals((Object)ExcelType.xlsx)) {
            return;
        }
        XSSFWorkbook workBook = (XSSFWorkbook)this.getWorkBook();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
        try {
            workBook.getSharedStringSource().readFrom((InputStream)byteArrayInputStream);
        }
        catch (IOException e) {
            log.error(CkLogger.getTrace(e));
        }
    }

    public String getDownloadSuffix() {
        return this.downloadSuffix;
    }

    public Workbook getWorkBook() {
        return this.workBook;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getCellIndex() {
        return this.cellIndex;
    }

    public int getDataSheetIndex() {
        return this.dataSheetIndex;
    }

    public List<String[]> getDataList() {
        return this.dataList;
    }

    public ExcelType getExcelType() {
        return this.excelType;
    }

    public int getPlaceHolderRow() {
        return this.placeHolderRow;
    }

    public List<String> getPlaceHolder() {
        return this.placeHolder;
    }

    public String getXH_NAME() {
        return this.XH_NAME;
    }

    public Map<String, String> getFIX_COL_INFO() {
        return this.FIX_COL_INFO;
    }

    public CkExcel setWorkBook(Workbook workBook) {
        this.workBook = workBook;
        return this;
    }

    public CkExcel setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
        return this;
    }

    public CkExcel setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
        return this;
    }

    public CkExcel setCellIndex(int cellIndex) {
        this.cellIndex = cellIndex;
        return this;
    }

    public static class CkCellStyle {
        private String placeHolderName;
        private CellStyle style;

        public boolean equals(Object o) {
            if (!(o instanceof String)) {
                return false;
            }
            if (ObjectJudge.isNull(o)) {
                return false;
            }
            return o.toString().equals(this.getPlaceHolderName());
        }

        public int hashCode() {
            return Objects.hash(this.placeHolderName, this.style);
        }

        public String getPlaceHolderName() {
            return this.placeHolderName;
        }

        public CellStyle getStyle() {
            return this.style;
        }

        public CkCellStyle setPlaceHolderName(String placeHolderName) {
            this.placeHolderName = placeHolderName;
            return this;
        }

        public CkCellStyle setStyle(CellStyle style) {
            this.style = style;
            return this;
        }

        public String toString() {
            return "CkExcel.CkCellStyle(placeHolderName=" + this.getPlaceHolderName() + ", style=" + this.getStyle() + ")";
        }

        public CkCellStyle(String placeHolderName, CellStyle style) {
            this.placeHolderName = placeHolderName;
            this.style = style;
        }
    }

    public static enum ExcelType {
        xls,
        xlsx;

    }
}

